/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.sse.AbstractServerEventContext;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.sse.ServerEventWaitForManager;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContextManager;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.core.notification.sse.behavior.AfterSentToAllContexts;
import org.silverpeas.core.notification.sse.behavior.IgnoreStoring;
import org.silverpeas.core.notification.sse.behavior.KeepAlwaysLastStored;
import org.silverpeas.core.notification.sse.behavior.StoreLastOnly;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.thread.ManagedThreadPoolException;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.thread.task.RequestTaskManager;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;

@Technical
@Bean
public class ServerEventDispatcherTask
extends AbstractRequestTask<AbstractRequestTask.ProcessContext> {
    private static final int MIN_LIFE_TIME = 40000;
    private static final ServerEventStore serverEventStore = new ServerEventStore();

    ServerEventDispatcherTask() {
    }

    static void unregisterContext(SilverpeasServerEventContext context) {
        SilverpeasServerEventContextManager.get().unregister(context);
    }

    static List<SilverpeasServerEventContext> getContextSnapshot() {
        return SilverpeasServerEventContextManager.get().getContextSnapshot();
    }

    public static void unregisterBySessionId(String sessionId) {
        ServerEventDispatcherTask.getContextSnapshot().stream().filter(c -> sessionId.equals(c.getSessionId())).forEach(ServerEventDispatcherTask::unregisterContext);
    }

    public static void registerContext(SilverpeasServerEventContext context) {
        serverEventStore.cleanExpired();
        SilverpeasServerEventContextManager.get().register(context);
    }

    public static Pair<Long, List<ServerEvent>> getLastServerEventsFromId(long lastServerEventId) {
        List<ServerEvent> serverEventsToSendAgain = serverEventStore.getFromId(lastServerEventId);
        long newLastServerEventId = serverEventsToSendAgain.isEmpty() ? lastServerEventId : serverEventsToSendAgain.get(serverEventsToSendAgain.size() - 1).getId();
        return Pair.of((Object)newLastServerEventId, serverEventsToSendAgain);
    }

    public static void dispatch(ServerEvent serverEventToDispatch) {
        if (NotificationManagerSettings.isSseEnabledFor(serverEventToDispatch) && ServerEventWaitForManager.get().mustSendImmediately(serverEventToDispatch)) {
            ServerEventDispatchRequest request = new ServerEventDispatchRequest(serverEventToDispatch);
            ServerEventDispatcherTask.push(request);
        }
    }

    private static void push(ServerEventDispatchRequest request) {
        RequestTaskManager.get().push(ServerEventDispatcherTask.class, request);
    }

    private static class StoredServerEvent {
        private final long storeTime = System.currentTimeMillis();
        private final ServerEvent serverEvent;

        private StoredServerEvent(ServerEvent serverEvent) {
            this.serverEvent = serverEvent;
        }

        long getStoreTime() {
            return this.storeTime;
        }

        ServerEvent getServerEvent() {
            return this.serverEvent;
        }
    }

    static class ServerEventStore {
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
        private final List<StoredServerEvent> synchronizedStore = new ArrayList<StoredServerEvent>();

        ServerEventStore() {
        }

        void cleanExpired() {
            long currentTime = System.currentTimeMillis();
            long maxLifeTime = Math.max(NotificationManagerSettings.getSseStoreEventLifeTime(), 40000);
            this.safeWrite(() -> {
                Iterator<StoredServerEvent> it = this.synchronizedStore.iterator();
                boolean done = false;
                while (it.hasNext() && !done) {
                    StoredServerEvent item = it.next();
                    boolean canProcess = !(item.getServerEvent() instanceof KeepAlwaysLastStored);
                    if (!canProcess) continue;
                    long lifetime = currentTime - item.getStoreTime();
                    if (lifetime >= maxLifeTime) {
                        it.remove();
                        SseLogger.get().debug(() -> MessageFormat.format("Removing expired {0} lifetime of {1}ms", item.getServerEvent(), lifetime));
                        continue;
                    }
                    done = true;
                }
                SseLogger.get().debug(() -> MessageFormat.format("Size of the server event store (after clean): {0}", this.synchronizedStore.size()));
            });
        }

        List<ServerEvent> getFromId(long lastServerEventId) {
            return this.safeRead(() -> this.synchronizedStore.stream().filter(i -> i.getServerEvent().getId() > lastServerEventId).map(StoredServerEvent::getServerEvent).collect(Collectors.toList()));
        }

        void add(ServerEvent serverEvent) {
            if (serverEvent.isValidId() && !(serverEvent instanceof IgnoreStoring)) {
                this.safeWrite(() -> {
                    if (serverEvent instanceof StoreLastOnly) {
                        this.removeAll((StoreLastOnly)serverEvent);
                    }
                    this.synchronizedStore.add(new StoredServerEvent(serverEvent));
                    SseLogger.get().debug(() -> MessageFormat.format("Add {0} into the store (size={1})", serverEvent, this.synchronizedStore.size()));
                });
            }
        }

        private void removeAll(StoreLastOnly storeLastOnly) {
            Class<?> classToIdentify = storeLastOnly.getClass();
            Iterator<StoredServerEvent> it = this.synchronizedStore.iterator();
            boolean done = false;
            while (it.hasNext() && !done) {
                StoredServerEvent item = it.next();
                if (!classToIdentify.isInstance(item.getServerEvent())) continue;
                StoreLastOnly itemEvent = (StoreLastOnly)item.getServerEvent();
                if (!storeLastOnly.getStoreDiscriminator().equals(itemEvent.getStoreDiscriminator())) continue;
                it.remove();
                SseLogger.get().debug(() -> MessageFormat.format("Remove {0} from the store (size={1})", item.getServerEvent(), this.synchronizedStore.size()));
                done = true;
            }
        }

        public void clear() {
            this.synchronizedStore.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        <T> T safeRead(Callable<T> process) {
            try {
                this.lock.readLock().lock();
                try {
                    T t = process.call();
                    return t;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }

        void safeWrite(Runnable process) {
            try {
                this.lock.writeLock().lock();
                try {
                    process.run();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
    }

    private static class ServerEventDispatchRequest
    implements AbstractRequestTask.Request<AbstractRequestTask.ProcessContext> {
        private final ServerEvent serverEventToDispatch;

        ServerEventDispatchRequest(ServerEvent serverEventToDispatch) {
            this.serverEventToDispatch = serverEventToDispatch;
        }

        @Override
        public String getReplacementId() {
            return this.serverEventToDispatch instanceof StoreLastOnly ? ((StoreLastOnly)this.serverEventToDispatch).getStoreDiscriminator() : null;
        }

        @Override
        public void process(AbstractRequestTask.ProcessContext context) {
            List<SilverpeasServerEventContext> safeContexts = this.getSafeContexts();
            if (!safeContexts.isEmpty()) {
                this.sendTo(safeContexts);
            }
            serverEventStore.add(this.serverEventToDispatch);
        }

        private void push(ServerEvent serverEventToDispatch, SilverpeasServerEventContext context, boolean completeAfterSend) {
            SilverLogger logger = SseLogger.get();
            ((AbstractServerEventContext)context).safeWrite(() -> {
                try {
                    this.sendNotConsumed(serverEventToDispatch, context, logger);
                    boolean sendPerformed = serverEventToDispatch.send(context, context.getSessionId(), context.getUser());
                    if (sendPerformed) {
                        logger.debug(() -> MessageFormat.format("Send done on {0}", context));
                    }
                    if (completeAfterSend && sendPerformed) {
                        context.close();
                        logger.debug(() -> MessageFormat.format("Complete requested after send on {0}", context));
                    }
                }
                catch (Exception e) {
                    logger.error("Can not send SSE", (Throwable)e);
                    ServerEventDispatcherTask.unregisterContext(context);
                }
            });
        }

        private void sendNotConsumed(ServerEvent serverEventToDispatch, SilverpeasServerEventContext context, SilverLogger logger) throws IOException {
            Long lastServerEventId = context.getLastServerEventId();
            if (lastServerEventId != null && serverEventToDispatch.isValidId()) {
                long serverEventId = serverEventToDispatch.getId();
                if (lastServerEventId < serverEventId - 1L) {
                    String sessionId = context.getSessionId();
                    User user = context.getUser();
                    for (ServerEvent notConsumedEvent : (List)ServerEventDispatcherTask.getLastServerEventsFromId(lastServerEventId).getSecond()) {
                        boolean sent = notConsumedEvent.send(context, sessionId, user);
                        if (!sent) continue;
                        logger.debug(() -> MessageFormat.format("Send of not consumed {0}", notConsumedEvent));
                    }
                }
                context.setLastServerEventId(null);
            }
        }

        private void sendTo(List<SilverpeasServerEventContext> safeContexts) {
            SseLogger.get().debug(() -> MessageFormat.format("Sending {0}", this.serverEventToDispatch));
            Map sorted = safeContexts.stream().collect(Collectors.groupingBy(SilverpeasServerEventContext::isSendPossible, Collectors.mapping(c -> c, Collectors.toList())));
            sorted.getOrDefault(Boolean.FALSE, Collections.emptyList()).forEach(ServerEventDispatcherTask::unregisterContext);
            Stream<SilverpeasServerEventContext> stream = sorted.getOrDefault(Boolean.TRUE, Collections.emptyList()).stream().filter(c -> this.serverEventToDispatch.isConcerned(c.getSessionId(), c.getUser()));
            int sseSendMaxThreadPool = NotificationManagerSettings.getSseSendMaxThreadPool();
            if (sseSendMaxThreadPool <= 1) {
                stream.forEach(c -> this.push(this.serverEventToDispatch, (SilverpeasServerEventContext)c, this.completeAfterSend()));
            } else {
                List threadedSends = stream.map(c -> () -> this.push(this.serverEventToDispatch, (SilverpeasServerEventContext)c, this.completeAfterSend())).collect(Collectors.toList());
                try {
                    ManagedThreadPool.getPool().invokeAndAwaitTermination(threadedSends, ManagedThreadPool.ExecutionConfig.defaultConfig().withMaxThreadPoolSizeOf(sseSendMaxThreadPool));
                }
                catch (ManagedThreadPoolException e) {
                    SseLogger.get().error((Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (this.serverEventToDispatch instanceof AfterSentToAllContexts) {
                SseLogger.get().debug(() -> MessageFormat.format("Performing treatment after sent of {0}", this.serverEventToDispatch));
                ((AfterSentToAllContexts)this.serverEventToDispatch).afterAllContexts();
            }
        }

        List<SilverpeasServerEventContext> getSafeContexts() {
            return ServerEventDispatcherTask.getContextSnapshot();
        }

        boolean completeAfterSend() {
            return false;
        }
    }
}

