/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPageHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPageWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDistanceAfterSepAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDistanceBeforeSepAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePrintOrientationAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRelWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWidthAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleFootnoteSepElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.odfdom.type.Percent;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.BorderPropertiesImpl;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class PageLayoutProperties {
    private static final String DEFAULT_LENGTH = "0in";
    private static final String DEFAULT_PERCENT = "0%";
    StylePageLayoutPropertiesElement mElement;
    StyleFootnoteSepElement mFootnoteSepElement;
    BorderPropertiesImpl mBorderPropertiesHandler;

    protected PageLayoutProperties() {
    }

    protected PageLayoutProperties(StylePageLayoutPropertiesElement pageLayoutProperties) {
        this.mElement = pageLayoutProperties;
        this.mFootnoteSepElement = (StyleFootnoteSepElement)pageLayoutProperties.getElementsByTagName(StyleFootnoteSepElement.ELEMENT_NAME.getQName()).item(0);
        this.mBorderPropertiesHandler = new BorderPropertiesImpl((OdfStylePropertiesBase)this.mElement);
    }

    public void setBorders(StyleTypeDefinitions.CellBordersType bordersType, Border border) {
        switch (bordersType) {
            case BOTTOM: {
                this.setBottomBorder(border);
                break;
            }
            case LEFT: {
                this.setLeftBorder(border);
                break;
            }
            case RIGHT: {
                this.setRightBorder(border);
                break;
            }
            case TOP: {
                this.setTopBorder(border);
                break;
            }
            case ALL_FOUR: {
                this.setBorder(border);
                break;
            }
            case LEFT_RIGHT: {
                this.setLeftBorder(border);
                this.setRightBorder(border);
                break;
            }
            case TOP_BOTTOM: {
                this.setTopBorder(border);
                this.setBottomBorder(border);
                break;
            }
            case NONE: {
                this.mElement.removeAttribute(StyleBorderLineWidthAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthBottomAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderBottomAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthTopAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderTopAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthLeftAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderLeftAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthRightAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderRightAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public Border getBorder() {
        return this.mBorderPropertiesHandler.getBorder();
    }

    public Border getTopBorder() {
        return this.mBorderPropertiesHandler.getTopBorder();
    }

    public Border getLeftBorder() {
        return this.mBorderPropertiesHandler.getLeftBorder();
    }

    public Border getRightBorder() {
        return this.mBorderPropertiesHandler.getRightBorder();
    }

    public Border getBottomBorder() {
        return this.mBorderPropertiesHandler.getBottomBorder();
    }

    public void setBorder(Border border) {
        this.mBorderPropertiesHandler.setBorder(border);
    }

    public void setBottomBorder(Border border) {
        this.mBorderPropertiesHandler.setBottomBorder(border);
    }

    public void setTopBorder(Border border) {
        this.mBorderPropertiesHandler.setTopBorder(border);
    }

    public void setLeftBorder(Border border) {
        this.mBorderPropertiesHandler.setLeftBorder(border);
    }

    public void setRightBorder(Border border) {
        this.mBorderPropertiesHandler.setRightBorder(border);
    }

    public void setMarginLeft(double marginLeft) {
        if (marginLeft == 0.0) {
            this.mElement.removeAttribute(FoMarginLeftAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginLeftAttribute(PageLayoutProperties.getInchValue(marginLeft));
        }
    }

    private static String getInchValue(double value) {
        String mmValueString = value + Length.Unit.MILLIMETER.abbr();
        String inchValueString = Length.mapToUnit((String)mmValueString, (Length.Unit)Length.Unit.INCH);
        return inchValueString;
    }

    public double getMarginLeft() {
        String valueString = this.mElement.getFoMarginLeftAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)valueString, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setMarginRight(double marginRight) {
        if (marginRight == 0.0) {
            this.mElement.removeAttribute(FoMarginRightAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginRightAttribute(PageLayoutProperties.getInchValue(marginRight));
        }
    }

    public double getMarginRight() {
        String valueString = this.mElement.getFoMarginRightAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)valueString, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setMarginTop(double marginTop) {
        if (marginTop == 0.0) {
            this.mElement.removeAttribute(FoMarginTopAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginTopAttribute(PageLayoutProperties.getInchValue(marginTop));
        }
    }

    public double getMarginTop() {
        String valueString = this.mElement.getFoMarginTopAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)valueString, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setMarginBottom(double marginBottom) {
        if (marginBottom == 0.0) {
            this.mElement.removeAttribute(FoMarginBottomAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginBottomAttribute(PageLayoutProperties.getInchValue(marginBottom));
        }
    }

    public double getMarginBottom() {
        String valueString = this.mElement.getFoMarginBottomAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)valueString, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public String getNumberFormat() {
        return this.mElement.getStyleNumFormatAttribute();
    }

    public void setNumberFormat(String format) {
        if (format == null) {
            this.mElement.removeAttribute(StyleNumFormatAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setStyleNumFormatAttribute(format);
        }
    }

    public double getPageWidth() {
        String valueString = this.mElement.getFoPageWidthAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)valueString, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setPageWidth(double pageWidth) {
        if (pageWidth == 0.0) {
            this.mElement.removeAttribute(FoPageWidthAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoPageWidthAttribute(PageLayoutProperties.getInchValue(pageWidth));
        }
    }

    public double getPageHeight() {
        String valueString = this.mElement.getFoPageHeightAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)valueString, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setPageHeight(double pageHeight) {
        if (pageHeight == 0.0) {
            this.mElement.removeAttribute(FoPageHeightAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoPageHeightAttribute(PageLayoutProperties.getInchValue(pageHeight));
        }
    }

    public String getPrintOrientation() {
        return this.mElement.getStylePrintOrientationAttribute();
    }

    public void setPrintOrientation(StyleTypeDefinitions.PrintOrientation orientation) {
        if (orientation == null) {
            this.mElement.removeAttribute(StylePrintOrientationAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setStylePrintOrientationAttribute(orientation.toString());
        }
    }

    public String getFootnoteSepAdjustment() {
        if (this.mFootnoteSepElement == null) {
            return StyleTypeDefinitions.AdjustmentStyle.LEFT.toString();
        }
        return this.mFootnoteSepElement.getStyleAdjustmentAttribute();
    }

    public String getFootnoteSepColor() {
        if (this.mFootnoteSepElement == null) {
            return null;
        }
        return this.mFootnoteSepElement.getStyleColorAttribute();
    }

    public double getFootnoteSepDistanceAfterSep() {
        if (this.mFootnoteSepElement == null) {
            return 0.0;
        }
        String value = this.mFootnoteSepElement.getStyleDistanceAfterSepAttribute();
        if (value == null) {
            value = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)value, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public double getFootnoteSepDistanceBeforeSep() {
        if (this.mFootnoteSepElement == null) {
            return 0.0;
        }
        String value = this.mFootnoteSepElement.getStyleDistanceBeforeSepAttribute();
        if (value == null) {
            value = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)value, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public String getFootnoteSepLineStyle() {
        if (this.mFootnoteSepElement == null) {
            return StyleTypeDefinitions.LineStyle.NONE.toString();
        }
        return this.mFootnoteSepElement.getStyleLineStyleAttribute();
    }

    public double getFootnoteSepWidth() {
        if (this.mFootnoteSepElement == null) {
            return 0.0;
        }
        String value = this.mFootnoteSepElement.getStyleRelWidthAttribute();
        if (value == null) {
            value = DEFAULT_PERCENT;
        }
        return Percent.valueOf((String)value).doubleValue();
    }

    public double getFootnoteSepThickness() {
        if (this.mFootnoteSepElement == null) {
            return 0.0;
        }
        String value = this.mFootnoteSepElement.getStyleWidthAttribute();
        if (value == null) {
            value = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)value, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setFootnoteSepProperties(StyleTypeDefinitions.AdjustmentStyle adjustment, Color color, double distanceAfterSep, double distanceBeforeSep, StyleTypeDefinitions.LineStyle lineStyle, Percent width, double thickness) {
        if (this.mFootnoteSepElement == null) {
            this.mFootnoteSepElement = this.mElement.newStyleFootnoteSepElement();
        }
        if (adjustment != null) {
            this.mFootnoteSepElement.setStyleAdjustmentAttribute(adjustment.toString());
        } else {
            this.mFootnoteSepElement.setStyleAdjustmentAttribute(StyleTypeDefinitions.AdjustmentStyle.LEFT.toString());
        }
        if (color != null) {
            this.mFootnoteSepElement.setStyleColorAttribute(color.toString());
        } else {
            this.mFootnoteSepElement.removeAttribute(StyleColorAttribute.ATTRIBUTE_NAME.getQName());
        }
        if (distanceAfterSep == 0.0) {
            this.mFootnoteSepElement.removeAttribute(StyleDistanceAfterSepAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mFootnoteSepElement.setStyleDistanceAfterSepAttribute(PageLayoutProperties.getInchValue(distanceAfterSep));
        }
        if (distanceBeforeSep == 0.0) {
            this.mFootnoteSepElement.removeAttribute(StyleDistanceBeforeSepAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mFootnoteSepElement.setStyleDistanceBeforeSepAttribute(PageLayoutProperties.getInchValue(distanceBeforeSep));
        }
        if (lineStyle == null) {
            this.mFootnoteSepElement.setStyleLineStyleAttribute(StyleTypeDefinitions.LineStyle.NONE.toString());
        } else {
            this.mFootnoteSepElement.setStyleLineStyleAttribute(lineStyle.toString());
        }
        if (width == null) {
            this.mFootnoteSepElement.removeAttribute(StyleRelWidthAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mFootnoteSepElement.setStyleRelWidthAttribute(width.toString());
        }
        if (thickness == 0.0) {
            this.mFootnoteSepElement.removeAttribute(StyleWidthAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mFootnoteSepElement.setStyleWidthAttribute(PageLayoutProperties.getInchValue(thickness));
        }
    }

    public void setWritingMode(StyleTypeDefinitions.WritingMode mode) {
        if (mode == null) {
            this.mElement.setStyleWritingModeAttribute(StyleTypeDefinitions.WritingMode.PAGE.toString());
        } else {
            this.mElement.setStyleWritingModeAttribute(mode.toString());
        }
    }

    public String getWritingMode() {
        return StyleTypeDefinitions.WritingMode.enumValueOf(this.mElement.getStyleWritingModeAttribute()).toString();
    }

    public void setFootnoteMaxHeight(double height) {
        this.mElement.setStyleFootnoteMaxHeightAttribute(PageLayoutProperties.getInchValue(height));
    }

    public double getFootnoteMaxHeight() {
        String valueString = this.mElement.getStyleFootnoteMaxHeightAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble((String)valueString, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public static PageLayoutProperties getOrCreatePageLayoutProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.PageLayoutProperties);
        return new PageLayoutProperties((StylePageLayoutPropertiesElement)properties);
    }

    public static PageLayoutProperties getPageLayoutProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getPropertiesElement(OdfStylePropertiesSet.PageLayoutProperties);
        if (properties != null) {
            return new PageLayoutProperties((StylePageLayoutPropertiesElement)properties);
        }
        return null;
    }
}

