/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.webdav;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.jcr.webdav.WebDavContext;
import org.silverpeas.core.jcr.webdav.WebDavTokenGenerator;

public class WebDavAccessOpener {
    public void open(User user, String documentURL, HttpServletResponse response) throws IOException {
        User aUser = user == null ? User.getCurrentRequester() : user;
        String token = WebDavTokenGenerator.getFor(aUser).generateToken(WebDavAccessOpener.fetchDocumentId(documentURL));
        WebDavContext webDAVContext = WebDavContext.createWebDavContext(token, documentURL);
        String webDavUrl = webDAVContext.getWebDavUrl();
        response.setContentType("application/javascript");
        response.setHeader("Content-Disposition", "inline; filename=launch.js");
        String customProtocolUrl = webDavUrl.startsWith("https:") ? webDavUrl.replaceFirst("^https", "spwebdavs") : webDavUrl.replaceFirst("^http", "spwebdav");
        response.getWriter().append("window.location.href='").append(customProtocolUrl).append("';");
    }

    private static String fetchDocumentId(String documentUrl) {
        String[] paths = documentUrl.split("/");
        if (paths.length > 3) {
            return paths[paths.length - 3];
        }
        return null;
    }
}

