/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.configuration;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.silverpeas.kernel.util.StringUtil;

public abstract class NodeStoreConfiguration {
    private final Properties properties;

    NodeStoreConfiguration(Properties props) {
        this.properties = props;
    }

    protected boolean getBoolean(String name, boolean defaultValue) {
        String value = this.properties.getProperty(name);
        if (StringUtil.isNotDefined((String)value)) {
            return defaultValue;
        }
        return StringUtil.getBooleanValue((String)value);
    }

    protected int getInteger(String name, int defaultValue) {
        String value = this.properties.getProperty(name);
        if (StringUtil.isNotDefined((String)value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    protected long getLong(String name, long defaultValue) {
        String value = this.properties.getProperty(name);
        if (StringUtil.isNotDefined((String)value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    protected String getString(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    protected List<String> getList(String name, List<String> defaultValue) {
        String value = this.properties.getProperty(name);
        if (StringUtil.isNotDefined((String)value)) {
            return defaultValue;
        }
        return Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
    }
}

