/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.silverpeas.core.persistence.OrderBy;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.sharing.model.Ticket;

@Entity
@Table(name="sb_filesharing_history")
public class DownloadDetail
extends BasicJpaEntity<DownloadDetail, UniqueLongIdentifier>
implements Serializable {
    private static final long serialVersionUID = -3552579238204831286L;
    @ManyToOne
    @JoinColumn(name="keyfile", columnDefinition="varchar(255)", nullable=false)
    private Ticket ticket;
    @Column(name="downloaddate", nullable=false)
    private Long downloadDate;
    @Column(name="downloadIp", nullable=false)
    private String userIP;

    public DownloadDetail() {
    }

    public DownloadDetail(Ticket ticket, Date downloadDate, String userIP) {
        this.ticket = ticket;
        this.downloadDate = downloadDate.getTime();
        this.userIP = userIP;
    }

    public void setId(Long id) {
        this.setId(Long.toString(id));
    }

    public String getKeyFile() {
        return this.ticket.getToken();
    }

    public void setKeyFile(Ticket ticket) {
        this.ticket = ticket;
    }

    public Date getDownloadDate() {
        return new Date(this.downloadDate);
    }

    public void setDownloadDate(Date downloadDate) {
        this.downloadDate = downloadDate.getTime();
    }

    public String getUserIP() {
        return this.userIP;
    }

    public void setUserIP(String userIP) {
        this.userIP = userIP;
    }

    public static enum QUERY_ORDER_BY {
        DOWNLOAD_DATE_ASC(OrderBy.asc((String)"downloaddate")),
        DOWNLOAD_DATE_DESC(OrderBy.desc((String)"downloaddate")),
        DOWNLOAD_IP_ASC(OrderBy.asc((String)"downloadIp")),
        DOWNLOAD_IP_DESC(OrderBy.desc((String)"downloadIp"));

        private final OrderBy orderBy;

        private QUERY_ORDER_BY(OrderBy orderBy) {
            this.orderBy = orderBy;
        }

        public OrderBy getOrderBy() {
            return this.orderBy;
        }
    }
}

