/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.silverpeas.kernel.bundle.SilverpeasBundle;
import org.silverpeas.kernel.bundle.VariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlSettingBundle
implements SilverpeasBundle {
    private static final String PARAM = "param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String RESOURCE_NOT_FOUND = "Can't find resource for bundle ";
    private static final String KEY = ", key ";
    private final Function<String, InputStream> loader;
    private final String name;
    private Document dom;

    protected XmlSettingBundle(String name, Function<String, InputStream> loader) {
        this.name = name;
        this.loader = loader;
    }

    @Override
    public Set<String> keySet() {
        Node rootNode = this.getCurrentRootNode();
        List<Node> nodes = XmlSettingBundle.findAllNodes(rootNode, PARAM_NAME, true);
        LinkedHashSet<String> keys = new LinkedHashSet<String>(nodes.size());
        for (Node node : nodes) {
            StringBuilder nodeFullName = new StringBuilder(node.getTextContent());
            Node parent = node.getParentNode();
            if (!PARAM.equals(parent.getNodeName())) continue;
            while ((parent = parent.getParentNode()).getNodeName().equals(rootNode.getNodeName())) {
                nodeFullName.append(parent.getNodeName()).append(".").append((CharSequence)nodeFullName);
            }
            keys.add(rootNode.getNodeName() + "." + nodeFullName);
        }
        return keys;
    }

    @Override
    public boolean containsKey(String key) {
        Object path = key;
        Node rootNode = this.getCurrentRootNode();
        if (!key.startsWith(rootNode.getNodeName())) {
            path = rootNode.getNodeName() + "." + key;
        }
        return this.keySet().contains(path);
    }

    @Override
    public String getBaseBundleName() {
        return this.name;
    }

    @Override
    public String getString(String key) {
        Node param = this.getParameter(key);
        String value = null;
        List<Node> values = XmlSettingBundle.findAllNodes(param, PARAM_VALUE, false);
        if (values.size() == 1) {
            value = VariableResolver.resolve(values.get(0).getTextContent());
        }
        return value;
    }

    public String[] getStringArray(String key) {
        Node param = this.getParameter(key);
        List<Node> valueNodes = XmlSettingBundle.findAllNodes(param, PARAM_VALUE, false);
        return (String[])valueNodes.stream().map(Node::getTextContent).toArray(String[]::new);
    }

    @Override
    public boolean exists() {
        try {
            Document document = this.getXMLDocument();
            return document != null;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public SettingSection getSettingSection(String path) {
        Node rootNode = this.getCurrentRootNode();
        Object absolutePath = path;
        if (!path.startsWith(rootNode.getNodeName())) {
            absolutePath = rootNode.getNodeName() + "." + path;
        }
        String[] nodePath = ((String)absolutePath).split("\\.");
        Node currentNode = this.getNodeAt(nodePath);
        return new SettingSection(this.name, currentNode);
    }

    public List<SettingSection> getAllSettingSection(String path) {
        NodePath nodePath = this.getNodePath(path);
        List<Node> nodes = XmlSettingBundle.findAllNodes(nodePath.parentNode, nodePath.path[nodePath.path.length - 1], false);
        if (nodes.isEmpty()) {
            throw new MissingResourceException(RESOURCE_NOT_FOUND + this.name + KEY + path, this.name, path);
        }
        return nodes.stream().map(n -> new SettingSection(this.name, (Node)n)).collect(Collectors.toList());
    }

    private NodePath getNodePath(String path) {
        Node rootNode = this.getCurrentRootNode();
        Object absolutePath = path;
        if (!path.startsWith(rootNode.getNodeName())) {
            absolutePath = rootNode.getNodeName() + "." + path;
        }
        String[] nodePath = ((String)absolutePath).split("\\.");
        Node parentNode = this.getNodeAt(Arrays.copyOf(nodePath, nodePath.length - 1));
        return new NodePath(nodePath, parentNode);
    }

    protected Node getCurrentRootNode() {
        return this.getXMLDocument().getDocumentElement();
    }

    private Document getXMLDocument() {
        if (this.dom == null) {
            Object theName = this.name;
            if (((String)theName).toLowerCase().endsWith(".xml")) {
                int suffixIdx = ((String)theName).lastIndexOf(46);
                theName = ((String)theName).substring(0, suffixIdx).replace('.', '/') + ((String)theName).substring(suffixIdx);
            } else {
                theName = ((String)theName).replace('.', '/') + ".xml";
            }
            try (InputStream stream = this.loader.apply((String)theName);){
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                builderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource(stream);
                this.dom = documentBuilder.parse(inputSource);
                this.dom.normalize();
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new MissingResourceException(e.getMessage() + this.name, this.name, "");
            }
        }
        return this.dom;
    }

    private Node getParameter(String key) {
        NodePath nodePath = this.getNodePath(key);
        List<Node> params = XmlSettingBundle.findAllNodes(nodePath.parentNode, PARAM, false);
        for (Node param : params) {
            Node paramName = XmlSettingBundle.findNode(param, PARAM_NAME, true);
            if (paramName == null || !paramName.getTextContent().equals(nodePath.path[nodePath.path.length - 1])) continue;
            return param;
        }
        throw new MissingResourceException(RESOURCE_NOT_FOUND + this.name + KEY + nodePath, this.name, String.join((CharSequence)".", nodePath.path));
    }

    private Node getNodeAt(String[] nodePath) {
        Node currentNode = this.getCurrentRootNode();
        int i = 0;
        while (i < nodePath.length - 1 && currentNode != null) {
            if (currentNode.getNodeName().equals(nodePath[i])) {
                if (!currentNode.hasChildNodes() || i >= nodePath.length - 1) continue;
                currentNode = this.findNextNode(nodePath[++i], currentNode);
                continue;
            }
            currentNode = null;
        }
        if (currentNode == null || nodePath.length > 0 && !currentNode.getNodeName().equals(nodePath[nodePath.length - 1])) {
            String key = Arrays.toString(nodePath);
            throw new MissingResourceException(RESOURCE_NOT_FOUND + this.name + KEY + key, this.name, key);
        }
        return currentNode;
    }

    private Node findNextNode(String anObject, Node currentNode) {
        NodeList childNodes = currentNode.getChildNodes();
        Node nextNode = null;
        for (int j = 0; j < childNodes.getLength() && nextNode == null; ++j) {
            Node childNode = childNodes.item(j);
            if (!childNode.getNodeName().equals(anObject)) continue;
            nextNode = childNode;
        }
        currentNode = nextNode;
        return currentNode;
    }

    private static Node findNode(Node node, String name, boolean recurse) {
        if (node.getNodeName().equals(name)) {
            return node;
        }
        if (node.hasChildNodes() && recurse) {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node found = XmlSettingBundle.findNode(list.item(i), name, true);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    private static List<Node> findAllNodes(Node node, String name, boolean recurse) {
        ArrayList<Node> v = new ArrayList<Node>(10);
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node found = XmlSettingBundle.findNode(list.item(i), name, recurse);
            if (found == null) continue;
            v.add(found);
        }
        return v;
    }

    public static class SettingSection
    extends XmlSettingBundle {
        private final Node node;

        private SettingSection(String bundleName, Node node) {
            super(bundleName, null);
            this.node = node;
        }

        public String getName() {
            return this.node.getNodeName();
        }

        public String getAttribute(String attribute) {
            String value = null;
            Node attributeNode = this.node.getAttributes().getNamedItem(attribute);
            if (attributeNode != null) {
                value = attributeNode.getNodeValue();
            }
            return value;
        }

        public Set<String> attributeSet() {
            NamedNodeMap attributeNodes = this.node.getAttributes();
            LinkedHashSet<String> attributes = new LinkedHashSet<String>(attributeNodes.getLength());
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                attributes.add(attributeNodes.item(i).getNodeName());
            }
            return attributes;
        }

        @Override
        protected Node getCurrentRootNode() {
            return this.node;
        }
    }

    private static class NodePath {
        public final String[] path;
        public final Node parentNode;

        public NodePath(String[] path, Node parentNode) {
            this.path = path;
            this.parentNode = parentNode;
        }
    }
}

