/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription;

import java.io.Serializable;
import javax.inject.Inject;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionService;

public abstract class AbstractProfiledResourceSubscriptionListener<R extends Serializable, T extends ResourceEvent<R>>
extends CDIResourceEventListener<T> {
    @Inject
    private SubscriptionService subscriptionService;

    public void onDeletion(T event) {
        Serializable object = event.getTransition().getBefore();
        SubscriptionResource resource = this.getSubscriptionResource(object);
        this.subscriptionService.unsubscribeByResource(resource);
    }

    public void onUpdate(T event) {
        Serializable object = event.getTransition().getAfter();
        boolean isEnabled = this.isSubscriptionEnabled(object);
        if (!isEnabled) {
            SubscriptionResource resource = this.getSubscriptionResource(object);
            this.subscriptionService.unsubscribeByResource(resource);
        }
    }

    protected SubscriptionService getSubscriptionService() {
        return this.subscriptionService;
    }

    protected abstract SubscriptionResource getSubscriptionResource(R var1);

    protected abstract boolean isSubscriptionEnabled(R var1);
}

