/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.invitation;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.persistence.jdbc.sql.SelectResultRowProcess;
import org.silverpeas.core.socialnetwork.invitation.Invitation;

@Repository
public class InvitationDao {
    private static final String INSERT_INVITATION = "INSERT INTO sb_sn_invitation (id, senderID, receiverId, message, invitationDate) VALUES (?, ?, ?, ?, ?)";
    private static final String DELETE_INVITATION = "DELETE FROM sb_sn_invitation WHERE id = ?";
    private static final String DELETE_SAME_INVITATIONS = "DELETE FROM sb_sn_invitation  WHERE id IN (SELECT invit.id FROM sb_sn_invitation invit, sb_sn_invitation tmp WHERE tmp.id = ? AND ((tmp.senderid= invit.senderid AND tmp.receiverid = invit.receiverid) OR (tmp.senderid = invit.receiverid AND tmp.receiverid = invit.senderid)))";
    private static final String SELECT_INVITATION = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE senderID = ? and receiverId= ?";
    private static final String SELECT_INVITATION_BY_ID = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE id = ? ";
    private static final String SELECT_ALL_INVITATIONS_SENT = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE senderID = ?";
    private static final String SELECT_ALL_INVITATIONS_RECEIVE = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE receiverId= ?";
    private static final String DELETE_ALL_INVITATIONS = "DELETE FROM sb_sn_invitation WHERE senderID = ? OR receiverId = ?";
    private static final SelectResultRowProcess<Invitation> INVITATION_MAPPER = row -> {
        Invitation invitation = new Invitation();
        invitation.setId(row.getInt("id"));
        invitation.setSenderId(row.getInt("senderID"));
        invitation.setReceiverId(row.getInt("receiverId"));
        invitation.setMessage(row.getString("message"));
        invitation.setInvitationDate(new Date(row.getTimestamp("invitationDate").getTime()));
        return invitation;
    };

    int createInvitation(Connection connection, Invitation invitation) throws SQLException {
        int id = DBUtil.getNextId((String)"sb_sn_invitation", (String)"id");
        JdbcSqlQuery.create((String)INSERT_INVITATION, (Object[])new Object[]{id, invitation.getSenderId(), invitation.getReceiverId(), invitation.getMessage(), Timestamp.from(Instant.now())}).executeWith(connection);
        return id;
    }

    public void deleteInvitation(Connection connection, int invitationId) throws SQLException {
        JdbcSqlQuery.create((String)DELETE_INVITATION, (Object[])new Object[]{invitationId}).executeWith(connection);
    }

    public void deleteSameInvitations(Connection connection, int invitationId) throws SQLException {
        JdbcSqlQuery.create((String)DELETE_SAME_INVITATIONS, (Object[])new Object[]{invitationId}).executeWith(connection);
    }

    public void deleteAllInvitations(Connection connection, int userId) throws SQLException {
        JdbcSqlQuery.create((String)DELETE_ALL_INVITATIONS, (Object[])new Object[]{userId, userId}).executeWith(connection);
    }

    public Invitation getInvitation(Connection connection, int senderId, int receiverId) throws SQLException {
        return (Invitation)JdbcSqlQuery.create((String)SELECT_INVITATION, (Object[])new Object[]{senderId, receiverId}).executeUniqueWith(connection, INVITATION_MAPPER);
    }

    public Invitation getInvitation(Connection connection, int id) throws SQLException {
        return (Invitation)JdbcSqlQuery.create((String)SELECT_INVITATION_BY_ID, (Object[])new Object[]{id}).executeUniqueWith(connection, INVITATION_MAPPER);
    }

    public boolean isExists(Connection connection, int senderId, int receiverId) throws SQLException {
        return this.getInvitation(connection, senderId, receiverId) != null;
    }

    public List<Invitation> getAllMyInvitationsSent(Connection connection, int myId) throws SQLException {
        return JdbcSqlQuery.create((String)SELECT_ALL_INVITATIONS_SENT, (Object[])new Object[]{myId}).executeWith(connection, INVITATION_MAPPER);
    }

    public List<Invitation> getAllMyInvitationsReceive(Connection connection, int myId) throws SQLException {
        return JdbcSqlQuery.create((String)SELECT_ALL_INVITATIONS_RECEIVE, (Object[])new Object[]{myId}).executeWith(connection, INVITATION_MAPPER);
    }
}

