/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.security.session.SilverpeasUserSession;
import org.silverpeas.kernel.cache.model.SimpleCache;

public abstract class SessionInfo
implements SilverpeasUserSession {
    public static final SessionInfo NoneSession = new SessionInfo(){};
    private final Object mutex;
    private final String sessionId;
    private final User userDetail;
    private final long openingTimestamp;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String ipAddress;
    private long lastAccessTimestamp;
    private long idleTimestamp;
    private SimpleCache cache;

    private SessionInfo() {
        this(null, null);
    }

    protected SessionInfo(String sessionId, User user) {
        this.mutex = this;
        this.sessionId = sessionId;
        this.userDetail = user;
        this.openingTimestamp = this.lastAccessTimestamp = System.currentTimeMillis();
        this.idleTimestamp = 0L;
        if (user != null) {
            this.cache = CacheAccessorProvider.getSessionCacheAccessor().newSessionCache(user);
        }
    }

    public String getId() {
        return this.getSessionId();
    }

    public User getUser() {
        return this.getUserDetail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIPAddress() {
        Object object = this.mutex;
        synchronized (object) {
            return this.ipAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIPAddress(String ip) {
        Object object = this.mutex;
        synchronized (object) {
            this.ipAddress = ip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessTimestamp() {
        Object object = this.mutex;
        synchronized (object) {
            return this.lastAccessTimestamp;
        }
    }

    public long getOpeningTimestamp() {
        return this.openingTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastIdleDuration() {
        this.checkIsNotOneShot();
        Object object = this.mutex;
        synchronized (object) {
            return System.currentTimeMillis() - this.idleTimestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsIdle() {
        this.checkIsNotOneShot();
        Object object = this.mutex;
        synchronized (object) {
            this.idleTimestamp = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsOneShot() {
        Object object = this.mutex;
        synchronized (object) {
            this.idleTimestamp = -1L;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UserDetail getUserDetail() {
        return (UserDetail)this.userDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastAccess() {
        this.checkIsNotOneShot();
        Object object = this.mutex;
        synchronized (object) {
            this.lastAccessTimestamp = System.currentTimeMillis();
            this.idleTimestamp = 0L;
        }
    }

    public <T> void setAttribute(String name, T value) {
        this.attributes.put(name, value);
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public void unsetAttribute(String name) {
        this.attributes.remove(name);
    }

    public void onClosed() {
        this.attributes.clear();
    }

    public boolean isDefined() {
        return this != NoneSession && this.getUserDetail() != null;
    }

    public boolean isAnonymous() {
        return this.getUserDetail() != null && this.getUserDetail().isAnonymous();
    }

    public boolean isOneShot() {
        return this.idleTimestamp == -1L;
    }

    public SimpleCache getCache() {
        return this.cache;
    }

    private void checkIsNotOneShot() {
        if (this.isOneShot()) {
            throw new IllegalStateException("Such operation isn't allowed with one-shot session");
        }
    }
}

