/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail.extractor;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.mail.extractor.EMLExtractor;
import org.silverpeas.core.mail.extractor.ExtractorException;
import org.silverpeas.core.mail.extractor.MSGExtractor;
import org.silverpeas.core.mail.extractor.MailExtractor;

public class Extractor {
    private Extractor() {
    }

    public static MailExtractor getExtractor(File file) throws ExtractorException {
        if (!file.exists() || file.isDirectory()) {
            throw new ExtractorException("file not found", new String[0]);
        }
        if (FilenameUtils.isExtension((String)file.getName(), (String)"eml")) {
            return new EMLExtractor(file);
        }
        if (FilenameUtils.isExtension((String)file.getName(), (String)"msg")) {
            return new MSGExtractor(file);
        }
        throw new ExtractorException("Extension not supported", new String[0]);
    }
}

