/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.thumbnail.model;

import java.nio.file.Path;
import java.util.Optional;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailReference;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class ThumbnailDetail
implements Thumbnail {
    private static final SettingBundle publicationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.publication.publicationSettings");
    public static final int THUMBNAIL_OBJECTTYPE_PUBLICATION_VIGNETTE = 1;
    private static final long serialVersionUID = 1L;
    private final ThumbnailReference reference;
    private String originalFileName = null;
    private String cropFileName = null;
    private int xStart = -1;
    private int yStart = -1;
    private int xLength = -1;
    private int yLength = -1;
    private String mimeType = null;

    public ThumbnailDetail(String instanceId, int objectId, int objectType) {
        this.reference = new ThumbnailReference(objectId, instanceId, objectType);
    }

    public ThumbnailReference getReference() {
        return this.reference;
    }

    public boolean isCropped() {
        return StringUtil.isDefined((String)this.cropFileName);
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public String getCropFileName() {
        return this.cropFileName;
    }

    public String getImageFileName() {
        return this.getCropFileName() != null ? this.getCropFileName() : this.getOriginalFileName();
    }

    public String getInstanceId() {
        return this.reference.getComponentInstanceId();
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getYStart() {
        return this.yStart;
    }

    public int getXLength() {
        return this.xLength;
    }

    public int getYLength() {
        return this.yLength;
    }

    public void setObjectId(int objectId) {
        this.reference.setObjectId(objectId);
    }

    public int getObjectId() {
        return this.reference.getObjectId();
    }

    public int getObjectType() {
        return this.reference.getObjectType();
    }

    public void setObjectType(int objectType) {
        this.reference.setObjectType(objectType);
    }

    public void setInstanceId(String instanceId) {
        this.reference.setComponentName(instanceId);
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public void setCropFileName(String cropFileName) {
        this.cropFileName = cropFileName;
    }

    public void setXStart(int xStart) {
        this.xStart = xStart;
    }

    public void setYStart(int yStart) {
        this.yStart = yStart;
    }

    public void setXLength(int xLength) {
        this.xLength = xLength;
    }

    public void setYLength(int yLength) {
        this.yLength = yLength;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean canBeCropped() {
        return StringUtil.isDefined((String)this.getOriginalFileName()) && !this.getOriginalFileName().startsWith("/");
    }

    public String getURL() {
        return this.computeURL(false);
    }

    public String getNonCroppedURL() {
        return this.computeURL(true);
    }

    private String computeURL(boolean nonCropped) {
        String image = this.getOriginalFileName();
        if (image.startsWith("/")) {
            return image;
        }
        if (!nonCropped && this.getCropFileName() != null) {
            image = this.getCropFileName();
        }
        return FileServerUtils.getUrl(this.getInstanceId(), "thumbnail", image, this.getMimeType(), publicationSettings.getString("imagesSubDirectory"));
    }

    public Optional<Path> getPath() {
        String image = this.getCropFileName() != null ? this.getCropFileName() : this.getOriginalFileName();
        if (image.startsWith("/")) {
            return Optional.empty();
        }
        String directory = FileRepositoryManager.getAbsolutePath(this.getInstanceId()) + publicationSettings.getString("imagesSubDirectory");
        return Optional.of(Path.of(directory, image));
    }
}

