/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.search.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class SearchCompletion {
    private static int pdcMaxRow = 100;
    private static int thesaurusMaxRow = 100;
    private static int keywordMaxRow = 100;
    private static final String PDC_QUERY = "SELECT DISTINCT name FROM sb_tree_tree where lower(name) like ?";
    private static final String THESAURUS_QUERY = "SELECT DISTINCT name FROM  sb_thesaurus_synonym where lower(name) like ?";
    private static final String KEYWORDS_QUERY = "SELECT DISTINCT label FROM sb_tagcloud_tagcloud  where lower(label) like ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSuggestions(String query) {
        query = query.toLowerCase();
        TreeSet<String> set = new TreeSet<String>();
        Statement ps = null;
        ResultSet rs = null;
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.pdcPeas.settings.pdcPeasSettings");
        int autocompletionMaxResults = settings.getInteger("autocompletionMaxResults");
        try (Connection con = DBUtil.openConnection();){
            List<String> pdcList = this.executeQuery(con, pdcMaxRow, query, PDC_QUERY);
            List<String> thesauruslist = this.executeQuery(con, thesaurusMaxRow, query, THESAURUS_QUERY);
            List<String> keywordsList = this.executeQuery(con, keywordMaxRow, query, KEYWORDS_QUERY);
            int numberOfPdcSuggest = this.getSize(autocompletionMaxResults, pdcList);
            int numberOfThesaurusSuggest = this.getSize(autocompletionMaxResults, thesauruslist);
            int numberOfKeywordsSuggest = this.getSize(autocompletionMaxResults, keywordsList);
            set.addAll(pdcList.subList(0, numberOfPdcSuggest));
            set.addAll(thesauruslist.subList(0, numberOfThesaurusSuggest));
            set.addAll(keywordsList.subList(0, numberOfKeywordsSuggest));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        finally {
            DBUtil.close(rs, ps);
        }
        return set;
    }

    private int getSize(int autocompletionMaxResults, List<String> list) {
        int numberOfSuggest = 0;
        int pdcSize = list.size();
        if (pdcSize > 0) {
            numberOfSuggest = autocompletionMaxResults / 3 > pdcSize ? pdcSize : pdcSize - autocompletionMaxResults / 3;
        }
        return numberOfSuggest;
    }

    private List<String> executeQuery(Connection con, int maxRow, String query, String sqlQuery) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        try (PreparedStatement ps = con.prepareStatement(sqlQuery);){
            ps.setString(1, query + "%");
            ps.setMaxRows(maxRow);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String result = rs.getString(1);
                    if (result == null) continue;
                    list.add(result.toLowerCase());
                }
            }
        }
        return list;
    }
}

