/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.search.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.silverpeas.core.index.indexing.IndexFileManager;
import org.silverpeas.core.index.indexing.model.IndexManager;
import org.silverpeas.core.index.search.model.IndexSearcher;
import org.silverpeas.core.index.search.model.ParseException;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class DidYouMeanSearcher {
    private List<SpellChecker> spellCheckers = new ArrayList<SpellChecker>();
    private String query = null;
    private final File uploadIndexDir = new File(IndexFileManager.getIndexUpLoadPath());
    @Inject
    private IndexSearcher indexSearcher;
    @Inject
    private IndexManager indexManager;

    private DidYouMeanSearcher() {
    }

    public String[] suggest(QueryDescription queryDescription) throws ParseException, IOException {
        Query parsedQuery;
        this.spellCheckers.clear();
        if (StringUtil.isNotDefined((String)queryDescription.getQuery())) {
            return ArrayUtil.emptyStringArray();
        }
        String field = "content";
        String language = queryDescription.getRequestedLanguage().orElse("");
        Analyzer analyzer = this.indexManager.getAnalyzer(language);
        QueryParser queryParser = new QueryParser("content", analyzer);
        try {
            parsedQuery = queryParser.parse(queryDescription.getQuery());
        }
        catch (org.apache.lucene.queryparser.classic.ParseException exception) {
            try {
                parsedQuery = queryParser.parse(QueryParserBase.escape((String)queryDescription.getQuery()));
            }
            catch (org.apache.lucene.queryparser.classic.ParseException pe) {
                throw new ParseException("DidYouMeanSearcher", pe);
            }
        }
        this.query = parsedQuery.toString("content");
        StringTokenizer tokens = new StringTokenizer(this.query);
        Set<String> spellIndexPaths = this.indexSearcher.getIndexPathSet(queryDescription.getWhereToSearch());
        try {
            while (tokens.hasMoreTokens()) {
                SpellChecker spellCheck = new SpellChecker((Directory)FSDirectory.open((Path)this.uploadIndexDir.toPath()));
                this.spellCheckers.add(spellCheck);
                String token = tokens.nextToken().replace("\"", "");
                for (String path : spellIndexPaths) {
                    File file = new File(path + "Spell");
                    if (!file.exists()) continue;
                    FSDirectory directory = FSDirectory.open((Path)file.toPath());
                    spellCheck.setSpellIndex((Directory)directory);
                    if (spellCheck.exist(token)) continue;
                    spellCheck.suggestSimilar(token, 1);
                }
            }
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return this.buildFinalResult();
    }

    private String[] buildFinalResult() throws IOException {
        StringBuilder currentSentence = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(this.query);
        int countTokens = tokens.countTokens();
        for (SpellChecker spellCheck : this.spellCheckers) {
            String currentToken;
            Object[] suggestWords = spellCheck.suggestSimilar(currentToken = tokens.nextToken(), 1);
            if (!ArrayUtil.isEmpty(suggestWords)) {
                this.getPrefixOperator(currentSentence, currentToken, false);
                currentSentence.append((String)suggestWords[0]);
                this.getSuffixOperator(currentSentence, currentToken, false);
                continue;
            }
            if (countTokens <= 1) continue;
            this.getPrefixOperator(currentSentence, currentToken, true);
            currentSentence.append(currentToken);
            this.getSuffixOperator(currentSentence, currentToken, true);
        }
        return new String[]{currentSentence.toString().replace("+", "").replace("-", "").replace("  ", " ").trim()};
    }

    private void getSuffixOperator(StringBuilder currentSentence, String currentToken, boolean originalString) {
        if (currentToken.endsWith("*")) {
            currentSentence.append("* ");
        } else if (currentToken.endsWith("\"") && !originalString) {
            currentSentence.append("\" ");
        } else {
            currentSentence.append(" ");
        }
    }

    private void getPrefixOperator(StringBuilder currentSentence, String currentToken, boolean originalString) {
        if (currentToken.startsWith("-")) {
            currentSentence.append(" NOT ");
        } else if (currentToken.startsWith("+")) {
            currentSentence.append(" AND ");
        } else if (currentToken.startsWith("\"") && !originalString) {
            currentSentence.append("\"");
        } else if (currentToken.startsWith("OR")) {
            currentSentence.append(" OR ");
        } else {
            currentSentence.append(" ");
        }
    }
}

