/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.text.Collator;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.constant.GroupState;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.util.StringUtil;

public class GroupDetail
implements Group {
    private static final long serialVersionUID = 4430574302630237352L;
    private String spaceId = null;
    private String id = null;
    private String specificId = null;
    private String domainId = null;
    private String superGroupId = null;
    private String name = "";
    private String description = "";
    private String rule = null;
    private String[] userIds = ArrayUtil.emptyStringArray();
    private Date creationDate = null;
    private Date saveDate = null;
    private GroupState state = GroupState.from(null);
    private Date stateSaveDate = null;
    private int nbTotalUsers = -1;

    public GroupDetail() {
    }

    public GroupDetail(GroupDetail toClone) {
        this.id = toClone.id;
        this.specificId = toClone.specificId;
        this.domainId = toClone.domainId;
        this.spaceId = toClone.spaceId;
        this.superGroupId = toClone.superGroupId;
        this.name = toClone.name;
        this.description = toClone.description;
        this.userIds = toClone.userIds;
        this.rule = toClone.rule;
        this.creationDate = toClone.getCreationDate();
        this.saveDate = toClone.getSaveDate();
        this.state = toClone.getState();
        this.stateSaveDate = toClone.getStateSaveDate();
        this.setTotalNbUsers(-1);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public String getSpecificId() {
        return this.specificId;
    }

    public void setSpecificId(String newSpecificId) {
        this.specificId = newSpecificId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String newDomainId) {
        this.domainId = newDomainId;
    }

    public String getSuperGroupId() {
        return this.superGroupId;
    }

    public void setSuperGroupId(String newSuperGroupId) {
        this.superGroupId = newSuperGroupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = Objects.requireNonNullElse(newDescription, "");
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setUserIds(String[] sUserIds) {
        this.userIds = ArrayUtil.nullToEmpty(sUserIds);
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public int compareTo(Group o) {
        return Collator.getInstance().compare(this.getName().toLowerCase(), o.getName().toLowerCase());
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public boolean isSynchronized() {
        return this.rule != null && !this.rule.trim().isEmpty();
    }

    public int getDirectUsersCount() {
        return this.getUserIds().length;
    }

    public int getTotalUsersCount() {
        if (this.nbTotalUsers < 0) {
            this.nbTotalUsers = GroupDetail.getOrganisationController().getAllSubUsersNumber(this.getId());
        }
        return this.nbTotalUsers;
    }

    public void setTotalNbUsers(int nbUsers) {
        this.nbTotalUsers = nbUsers;
    }

    protected static OrganizationController getOrganisationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    public boolean isRoot() {
        return !StringUtil.isDefined((String)this.superGroupId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupDetail other = (GroupDetail)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.specificId, other.specificId) && Objects.equals(this.domainId, other.domainId) && Objects.equals(this.superGroupId, other.superGroupId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.rule, other.rule) && Objects.equals(this.getDirectUsersCount(), other.getDirectUsersCount());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.specificId, this.domainId, this.superGroupId, this.name, this.description, this.rule, this.getDirectUsersCount());
    }

    public List<GroupDetail> getSubGroups() {
        return Arrays.asList((GroupDetail[])GroupDetail.getOrganisationController().getAllSubGroups(this.getId()));
    }

    public List<UserDetail> getAllUsers() {
        return Arrays.asList((UserDetail[])GroupDetail.getOrganisationController().getAllUsersOfGroup(this.getId()));
    }

    public List<UserDetail> getUsers() {
        return Stream.of(this.getUserIds()).map(GroupDetail.getOrganisationController()::getUserDetail).map(UserDetail.class::cast).collect(Collectors.toList());
    }

    public boolean isValidState() {
        return !GroupState.UNKNOWN.equals((Object)this.state) && !this.isRemovedState();
    }

    public boolean isRemovedState() {
        return GroupState.REMOVED.equals((Object)this.state);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }

    public GroupState getState() {
        return this.state;
    }

    public void setState(GroupState state) {
        this.state = state != null ? state : GroupState.from(null);
    }

    public Date getStateSaveDate() {
        return this.stateSaveDate;
    }

    public boolean isCommunityGroup() {
        return this.spaceId != null;
    }

    public void setStateSaveDate(Date stateSaveDate) {
        this.stateSaveDate = stateSaveDate;
    }
}

