/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.quota.constant.QuotaType;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.exception.QuotaRuntimeException;
import org.silverpeas.core.admin.quota.model.Quota;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceHomePageType;
import org.silverpeas.core.admin.space.SpaceI18N;
import org.silverpeas.core.admin.space.SpaceInstLazyDataLoader;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.space.SpaceServiceProvider;
import org.silverpeas.core.admin.space.quota.ComponentSpaceQuotaKey;
import org.silverpeas.core.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.i18n.LocalizedResource;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.SpaceAccessControl;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.memory.MemoryUnit;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.StringUtil;

public class SpaceInst
extends AbstractI18NBean<SpaceI18N>
implements Serializable,
Identifiable,
Securable,
LocalizedResource,
WithPermanentLink {
    public static final String SPACE_KEY_PREFIX = "WA";
    public static final String PERSONAL_SPACE_ID = "-10";
    public static final String DEFAULT_SPACE_ID = "-20";
    private static final long serialVersionUID = 4695928610067045964L;
    public static final int FP_TYPE_STANDARD = SpaceHomePageType.STANDARD.ordinal();
    public static final int FP_TYPE_COMPONENT_INST = SpaceHomePageType.COMPONENT_INST.ordinal();
    public static final int FP_TYPE_PORTLET = SpaceHomePageType.PORTLET.ordinal();
    public static final int FP_TYPE_HTML_PAGE = SpaceHomePageType.HTML_PAGE.ordinal();
    public static final String STATUS_REMOVED = "R";
    public static final String QUOTA_STORAGE_PREFIX_KEY = String.valueOf(SpaceInst.class) + "@DataStorageQuota@";
    public static final String QUOTA_STORAGE_REACHED_PREFIX_KEY = String.valueOf(SpaceInst.class) + "@ReachedDataStorageQuota@";
    public static final String QUOTA_COMPONENT_PREFIX_KEY = String.valueOf(SpaceInst.class) + "@ComponentQuota@";
    public static final String QUOTA_COMPONENT_REACHED_PREFIX_KEY = String.valueOf(SpaceInst.class) + "@ReachedComponentQuota@";
    private String id;
    private String domainFatherId;
    private String creatorUserId;
    private int firstPageType;
    private String firstPageExtraParam;
    private int orderNum;
    private Date createDate = null;
    private Date updateDate = null;
    private Date removeDate = null;
    private String status = null;
    private UserDetail creator;
    private UserDetail updater;
    private UserDetail remover;
    private String updaterUserId;
    private String removerUserId;
    private boolean inheritanceBlocked = false;
    private String look = null;
    private final SpaceInstLazyDataLoader data = new SpaceInstLazyDataLoader(this);
    private int level;
    private boolean displaySpaceFirst;
    private boolean isPersonalSpace;
    private boolean isCommunitySpace;

    @Override
    protected Class<SpaceI18N> getTranslationType() {
        return SpaceI18N.class;
    }

    public SpaceInst() {
        this.id = "";
        this.domainFatherId = "";
        this.creatorUserId = "";
        this.firstPageType = 0;
        this.firstPageExtraParam = "";
        this.orderNum = 0;
        this.level = 0;
        this.displaySpaceFirst = true;
        this.isPersonalSpace = false;
    }

    public SpaceInst(SpaceInst si) {
        super(si);
        this.setDescription(si.getDescription());
        this.setDisplaySpaceFirst(si.displaySpaceFirst);
        this.setFirstPageExtraParam(si.firstPageExtraParam);
        this.setFirstPageType(si.firstPageType);
        this.setInheritanceBlocked(si.inheritanceBlocked);
        this.setLook(si.look);
        this.setName(si.getName());
        this.setLanguage(si.getLanguage());
        this.setPersonalSpace(si.isPersonalSpace);
        si.getTranslations().values().forEach(this::addTranslation);
    }

    public BasicIdentifier getIdentifier() {
        return new BasicIdentifier(this.getLocalId(), this.getId());
    }

    public void setLocalId(int id) {
        this.id = String.valueOf(id);
    }

    public int getLocalId() {
        return StringUtil.isDefined((String)this.id) ? Integer.parseInt(this.id) : -1;
    }

    public String getId() {
        return SPACE_KEY_PREFIX + this.id;
    }

    public void setDomainFatherId(String sDomainFatherId) {
        this.domainFatherId = sDomainFatherId;
    }

    public String getDomainFatherId() {
        return this.domainFatherId;
    }

    @Override
    public String getName(String language) {
        if (this.isPersonalSpace) {
            return ResourceLocator.getGeneralLocalizationBundle((String)language).getString("GML.personalSpace");
        }
        return super.getName(language);
    }

    public void setCreatorUserId(String sCreatorUserId) {
        this.creatorUserId = sCreatorUserId;
        this.creator = null;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setFirstPageType(int iFirstPageType) {
        this.firstPageType = iFirstPageType;
    }

    public int getFirstPageType() {
        return this.firstPageType;
    }

    public void setOrderNum(int iOrderNum) {
        this.orderNum = iOrderNum;
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setFirstPageExtraParam(String sFirstPageExtraParam) {
        this.firstPageExtraParam = sFirstPageExtraParam;
    }

    public String getFirstPageExtraParam() {
        return this.firstPageExtraParam;
    }

    public List<SpaceInst> getSubSpaces() {
        return this.data.safeRead(SpaceInstLazyDataLoader.SafeDataAccessor::getCopyOfSubSpaces);
    }

    public void copyDataFrom(SpaceInst other) {
        this.data.copy(other.data);
    }

    public void setData(List<SpaceProfileInst> profiles, List<String> subSpaceIds, List<String> componentIds) {
        this.resetData();
        this.data.manualWrite(d -> {
            d.getProfiles().addAll(profiles);
            d.getSubSpaceIds().addAll(subSpaceIds);
            d.getComponentIds().addAll(componentIds);
        });
    }

    public void resetData() {
        this.data.reset();
    }

    public void addComponentInst(ComponentInst componentInst) {
        this.data.safeWrite(d -> {
            String cId = componentInst.getId();
            List<String> c = d.getComponentIds();
            if (!c.contains(cId)) {
                c.add(cId);
            }
        });
    }

    public void deleteComponentInst(ComponentInst componentInst) {
        String cId = componentInst.getId();
        this.data.safeWrite(d -> d.getComponentIds().removeIf(cId::equals));
    }

    public List<ComponentInst> getAllComponentsInst() {
        return this.data.safeRead(SpaceInstLazyDataLoader.SafeDataAccessor::getCopyOfComponents);
    }

    public List<SilverpeasComponentInstance> getAllComponentInstances() {
        List componentInstances = this.data.safeRead(d -> d.getCopyOfComponents().stream().map(SilverpeasComponentInstance.class::cast).collect(Collectors.toList()));
        if (this.isPersonalSpace()) {
            PersonalComponent.getAll().forEach(p -> componentInstances.add(PersonalComponentInstance.from(this.getCreator(), p)));
        }
        return componentInstances;
    }

    public void addSpaceProfileInst(SpaceProfileInst spaceProfileInst) {
        spaceProfileInst.setSpaceFatherId(String.valueOf(this.getLocalId()));
        this.data.safeWrite(d -> {
            List<SpaceProfileInst> p = d.getProfiles();
            if (StringUtil.isDefined((String)spaceProfileInst.getId())) {
                p.removeIf(i -> i.getId().equals(spaceProfileInst.getId()));
            } else {
                p.remove(spaceProfileInst);
            }
            p.add(spaceProfileInst);
        });
    }

    public void deleteSpaceProfileInst(SpaceProfileInst spaceProfileInst) {
        this.data.safeWrite(d -> d.getProfiles().removeIf(i -> i.getId().equals(spaceProfileInst.getId())));
    }

    public List<SpaceProfileInst> getAllSpaceProfilesInst() {
        return this.data.safeRead(SpaceInstLazyDataLoader.SafeDataAccessor::getCopyOfProfiles);
    }

    public List<SpaceProfileInst> getSpaceProfileInst(String spaceProfileName) {
        return this.data.safeRead(d -> d.streamProfiles().filter(i -> i.getName().equals(spaceProfileName)).collect(Collectors.toList()));
    }

    @Nullable
    public SpaceProfileInst getDirectSpaceProfileInst(String spaceProfileName) {
        return this.getSpaceProfileInst(spaceProfileName, false);
    }

    @Nullable
    public SpaceProfileInst getInheritedSpaceProfileInst(String spaceProfileName) {
        return this.getSpaceProfileInst(spaceProfileName, true);
    }

    private SpaceProfileInst getSpaceProfileInst(String spaceProfileName, boolean inherited) {
        return this.data.safeRead(d -> d.streamProfiles().filter(i -> i.isInherited() == inherited).filter(i -> i.getName().equals(spaceProfileName)).findFirst().orElse(null));
    }

    public List<SpaceProfileInst> getInheritedProfiles() {
        return this.data.safeRead(d -> d.streamProfiles().filter(BaseRightProfile::isInherited).collect(Collectors.toList()));
    }

    public List<SpaceProfileInst> getProfiles() {
        return this.data.safeRead(d -> d.streamProfiles().filter(Predicate.not(BaseRightProfile::isInherited)).collect(Collectors.toList()));
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isRoot() {
        return !StringUtil.isDefined((String)this.getDomainFatherId()) || "0".equals(this.getDomainFatherId()) || "-1".equals(this.getDomainFatherId());
    }

    public Date getCreationDate() {
        return this.createDate;
    }

    public void setCreationDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getRemovalDate() {
        return this.removeDate;
    }

    public void setRemovalDate(Date removeDate) {
        this.removeDate = removeDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public void setLastUpdate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getRemoverUserId() {
        return this.removerUserId;
    }

    public void setRemoverUserId(String removerUserId) {
        this.removerUserId = removerUserId;
        this.remover = null;
    }

    public String getUpdaterUserId() {
        return this.updaterUserId;
    }

    public void setUpdaterUserId(String updaterUserId) {
        this.updaterUserId = updaterUserId;
        this.updater = null;
    }

    public boolean isInheritanceBlocked() {
        return this.inheritanceBlocked;
    }

    public void setInheritanceBlocked(boolean isInheritanceBlocked) {
        this.inheritanceBlocked = isInheritanceBlocked;
    }

    public String getLook() {
        return this.look;
    }

    public void setLook(String look) {
        this.look = look;
    }

    public User getCreator() {
        if (this.creator == null && StringUtil.isDefined((String)this.creatorUserId)) {
            this.creator = UserDetail.getById(this.creatorUserId);
        }
        return this.creator;
    }

    public User getLastUpdater() {
        if (this.updater == null && StringUtil.isDefined((String)this.updaterUserId)) {
            this.updater = UserDetail.getById(this.updaterUserId);
        }
        return this.updater;
    }

    public User getRemover() {
        if (this.remover == null && StringUtil.isDefined((String)this.removerUserId)) {
            this.remover = UserDetail.getById(this.removerUserId);
        }
        return this.remover;
    }

    public boolean isDisplaySpaceFirst() {
        return this.displaySpaceFirst;
    }

    public void setDisplaySpaceFirst(boolean isDisplaySpaceFirst) {
        this.displaySpaceFirst = isDisplaySpaceFirst;
    }

    public void setPersonalSpace(boolean isPersonalSpace) {
        this.isPersonalSpace = isPersonalSpace;
    }

    public boolean isPersonalSpace() {
        return this.isPersonalSpace;
    }

    public boolean isCommunitySpace() {
        return this.isCommunitySpace;
    }

    public void setCommunitySpace(boolean communitySpace) {
        this.isCommunitySpace = communitySpace;
    }

    public Quota getComponentSpaceQuota() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        return (Quota)cache.computeIfAbsent((Object)(QUOTA_COMPONENT_PREFIX_KEY + this.getLocalId()), Quota.class, () -> {
            try {
                return SpaceServiceProvider.getComponentSpaceQuotaService().get(ComponentSpaceQuotaKey.from(this));
            }
            catch (QuotaException qe) {
                throw new QuotaRuntimeException("Cannot get quota for space", (Throwable)((Object)qe));
            }
        });
    }

    public void clearComponentSpaceQuotaCache() {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().remove((Object)(QUOTA_COMPONENT_PREFIX_KEY + this.getLocalId()));
    }

    public void setComponentSpaceQuotaMaxCount(long componentSpaceQuotaMaxCount) throws QuotaException {
        Quota componentSpaceQuota = this.getComponentSpaceQuota();
        componentSpaceQuota.setMaxCount(componentSpaceQuotaMaxCount);
        componentSpaceQuota.validateBounds();
    }

    @NonNull
    private Quota getReachedComponentSpaceQuota() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        Quota quota = (Quota)cache.computeIfAbsent((Object)(QUOTA_COMPONENT_REACHED_PREFIX_KEY + this.getLocalId()), Quota.class, () -> SpaceServiceProvider.getComponentSpaceQuotaService().getQuotaReachedFromSpacePath(ComponentSpaceQuotaKey.from(this)));
        return Objects.requireNonNull(quota);
    }

    public boolean isComponentSpaceQuotaReached() {
        return this.getReachedComponentSpaceQuota().isReached();
    }

    public String getComponentSpaceQuotaReachedErrorMessage(String language) {
        return this.getQuotaReachedErrorMessage(this.getReachedComponentSpaceQuota(), language, "componentSpaceQuotaReached");
    }

    public Quota getDataStorageQuota() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        return (Quota)cache.computeIfAbsent((Object)(QUOTA_STORAGE_PREFIX_KEY + this.getLocalId()), Quota.class, () -> {
            try {
                return SpaceServiceProvider.getDataStorageSpaceQuotaService().get(DataStorageSpaceQuotaKey.from(this));
            }
            catch (QuotaException qe) {
                throw new QuotaRuntimeException("Cannot get quota for data storage", (Throwable)((Object)qe));
            }
        });
    }

    public void clearDataStorageQuotaCache() {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().remove((Object)(QUOTA_STORAGE_PREFIX_KEY + this.getLocalId()));
    }

    public void setDataStorageQuotaMaxCount(long dataStorageQuotaMaxCount) throws QuotaException {
        Quota dataStorageQuota = this.getDataStorageQuota();
        dataStorageQuota.setMaxCount(dataStorageQuotaMaxCount);
        dataStorageQuota.validateBounds();
    }

    @NonNull
    private Quota getReachedDataStorageQuota() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        Quota quota = (Quota)cache.computeIfAbsent((Object)(QUOTA_STORAGE_REACHED_PREFIX_KEY + this.getLocalId()), Quota.class, () -> SpaceServiceProvider.getDataStorageSpaceQuotaService().getQuotaReachedFromSpacePath(DataStorageSpaceQuotaKey.from(this)));
        return Objects.requireNonNull(quota);
    }

    public boolean isDataStorageQuotaReached() {
        return this.getReachedDataStorageQuota().isReached();
    }

    public String getDataStorageQuotaReachedErrorMessage(String language) {
        return this.getQuotaReachedErrorMessage(this.getReachedDataStorageQuota(), language, "dataStorageQuotaReached");
    }

    private String getQuotaReachedErrorMessage(Quota quotaReached, String language, String stringTemplateFile) {
        if (!QuotaType.COMPONENTS_IN_SPACE.equals((Object)quotaReached.getType())) {
            quotaReached = new Quota(quotaReached);
            quotaReached.setMinCount(UnitUtil.convertTo((long)quotaReached.getMinCount(), (MemoryUnit)MemoryUnit.B, (MemoryUnit)MemoryUnit.MB));
            quotaReached.setMaxCount(UnitUtil.convertTo((long)quotaReached.getMaxCount(), (MemoryUnit)MemoryUnit.B, (MemoryUnit)MemoryUnit.MB));
            quotaReached.setCount(UnitUtil.convertTo((long)quotaReached.getCount(), (MemoryUnit)MemoryUnit.B, (MemoryUnit)MemoryUnit.MB));
        }
        SpaceInstLight space = OrganizationControllerProvider.getOrganisationController().getSpaceInstLightById(quotaReached.getResourceId());
        SilverpeasTemplate template = SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"admin/space/quota");
        template.setAttribute("quota", (Object)quotaReached);
        if (space.getLocalId() != new SpaceInstLight(this).getLocalId()) {
            template.setAttribute("fromSpaceId", (Object)space.getLocalId());
            template.setAttribute("fromSpaceName", (Object)space.getName());
        }
        if (!StringUtil.isDefined((String)language)) {
            language = I18NHelper.DEFAULT_LANGUAGE;
        }
        return template.applyFileTemplate(stringTemplateFile + "_" + language);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SpaceInst) {
            SpaceInst other = (SpaceInst)obj;
            return Objects.equals(other.createDate, this.createDate) && Objects.equals(other.id, this.id) && Objects.equals(other.level, this.level) && Objects.equals(other.look, this.look) && Objects.equals(other.firstPageType, this.firstPageType) && Objects.equals(other.orderNum, this.orderNum) && Objects.equals(other.creatorUserId, this.creatorUserId) && Objects.equals(other.getDescription(), this.getDescription()) && Objects.equals(other.domainFatherId, this.domainFatherId) && Objects.equals(other.firstPageExtraParam, this.firstPageExtraParam) && Objects.equals(other.getName(), this.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.createDate, this.id, this.level, this.look, this.firstPageType, this.orderNum, this.creatorUserId, this.getDescription(), this.domainFatherId, this.firstPageExtraParam, this.getName());
    }

    public String getPermalink() {
        return URLUtil.getSimpleURL(0, this.getId());
    }

    public boolean isRemoved() {
        return STATUS_REMOVED.equals(this.getStatus());
    }

    public boolean canBeAccessedBy(User user) {
        return SpaceAccessControl.get().isUserAuthorized(user.getId(), (Object)this.getId());
    }

    public boolean canBeModifiedBy(User user) {
        return SpaceAccessControl.get().hasUserSpaceManagementAuthorization(user.getId(), this.getId());
    }

    public boolean canBeFiledInBy(User user) {
        return this.canBeModifiedBy(user);
    }
}

