/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPEntry;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSettings;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;

public class LDAPSynchroCache {
    protected Map<String, String> userSpecificIds = null;
    protected LDAPSettings driverSettings = null;

    public void init(LDAPSettings driverSettings) {
        this.driverSettings = driverSettings;
    }

    public void beginSynchronization() {
        if (this.driverSettings.isSynchroCacheEnabled()) {
            this.userSpecificIds = new HashMap<String, String>();
        }
    }

    public void endSynchronization() {
        if (this.userSpecificIds != null) {
            this.userSpecificIds.clear();
            this.userSpecificIds = null;
        }
    }

    public void addUser(LDAPEntry userEntry) {
        if (this.userSpecificIds != null) {
            this.userSpecificIds.put(userEntry.getDN(), LDAPUtility.getFirstAttributeValue(userEntry, this.driverSettings.getUsersIdField()));
        }
    }

    public void addUser(String theDN, String theId) {
        if (this.userSpecificIds != null) {
            this.userSpecificIds.put(theDN, theId);
        }
    }

    public String getUserId(String theDN) {
        if (this.userSpecificIds != null) {
            return this.userSpecificIds.get(theDN);
        }
        return null;
    }
}

