/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.admin.domain.DomainService;
import org.silverpeas.core.admin.domain.DomainType;
import org.silverpeas.core.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.core.admin.quota.service.QuotaService;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Provider
public class DomainServiceProvider {
    @Inject
    @Named(value="externalDomainService")
    private DomainService externalDomainService;
    @Inject
    @Named(value="sqlDomainService")
    private DomainService sqlDomainService;
    @Inject
    private QuotaService<UserDomainQuotaKey> userDomainQuotaService;

    private static DomainServiceProvider getProvider() {
        return (DomainServiceProvider)ServiceProvider.getService(DomainServiceProvider.class, (Annotation[])new Annotation[0]);
    }

    public static DomainService getDomainService(DomainType type) {
        switch (type) {
            case SCIM: 
            case GOOGLE: 
            case LDAP: {
                return DomainServiceProvider.getProvider().externalDomainService;
            }
            case SQL: {
                return DomainServiceProvider.getProvider().sqlDomainService;
            }
        }
        SilverLogger.getLogger(DomainServiceProvider.class).error("Only SQL and SILVERPEAS Domain Services are implemented", new Object[0]);
        return null;
    }

    public static QuotaService<UserDomainQuotaKey> getUserDomainQuotaService() {
        return DomainServiceProvider.getProvider().userDomainQuotaService;
    }

    private DomainServiceProvider() {
    }
}

