/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.component.model.ComponentI18N;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.SilverpeasSharedComponentInstance;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ComponentInst
extends AbstractI18NBean<ComponentI18N>
implements SilverpeasSharedComponentInstance,
WithPermanentLink {
    private static final long serialVersionUID = 1L;
    private static final Pattern COMPONENT_INSTANCE_IDENTIFIER = Pattern.compile("^([a-zA-Z-_]+)(\\d+)$");
    public static final String STATUS_REMOVED = "R";
    @XmlAttribute
    private String id = "";
    private String name;
    private String domainFatherId;
    private int order;
    private Date createDate = null;
    private Date updateDate = null;
    private Date removeDate = null;
    private String status = null;
    private String creatorUserId;
    private UserDetail creator;
    private String updaterUserId;
    private UserDetail updater;
    private String removerUserId;
    private UserDetail remover;
    private boolean isPublic;
    private boolean isHidden;
    private boolean isInheritanceBlocked = false;
    private final List<ProfileInst> profiles = Collections.synchronizedList(new ArrayList());
    private transient List<Parameter> parameters = null;

    @Override
    protected Class<ComponentI18N> getTranslationType() {
        return ComponentI18N.class;
    }

    public ComponentInst() {
        this.name = "";
        this.domainFatherId = "";
        this.order = 0;
        this.isPublic = false;
        this.isHidden = false;
    }

    public ComponentInst(ComponentInst ci) {
        super(ci);
        this.name = ci.name;
        this.domainFatherId = ci.domainFatherId;
        this.order = ci.order;
        this.createDate = ci.createDate;
        this.updateDate = ci.updateDate;
        this.removeDate = ci.removeDate;
        this.status = ci.status;
        this.creatorUserId = ci.creatorUserId;
        this.creator = ci.creator;
        this.updaterUserId = ci.updaterUserId;
        this.updater = ci.updater;
        this.removerUserId = ci.removerUserId;
        this.remover = ci.remover;
        this.isPublic = ci.isPublic;
        this.isHidden = ci.isHidden;
        this.isInheritanceBlocked = ci.isInheritanceBlocked;
        ci.profiles.stream().map(ProfileInst::new).forEach(this::addProfileInst);
        if (ci.parameters != null) {
            this.parameters = ci.parameters.stream().map(Parameter::new).collect(Collectors.toList());
        }
        this.setTranslations(ci.getClonedTranslations());
    }

    public static String getComponentName(String componentInstanceId) {
        String componentName = null;
        Matcher matcher = COMPONENT_INSTANCE_IDENTIFIER.matcher(componentInstanceId);
        if (matcher.matches()) {
            componentName = matcher.group(1);
        }
        return componentName;
    }

    public static int getComponentLocalId(String componentInstanceId) {
        Matcher matcher;
        int componentId = -1;
        if (StringUtil.isDefined((String)componentInstanceId) && (matcher = COMPONENT_INSTANCE_IDENTIFIER.matcher(componentInstanceId)).matches()) {
            componentId = Integer.parseInt(matcher.group(2));
        }
        return componentId;
    }

    public BasicIdentifier getIdentifier() {
        return new BasicIdentifier(this.getLocalId(), this.getId());
    }

    public String getId() {
        return this.name + this.id;
    }

    public void setLocalId(int id) {
        this.id = String.valueOf(id);
    }

    public int getLocalId() {
        return StringUtil.isDefined((String)this.id) ? Integer.parseInt(this.id) : -1;
    }

    @Override
    public void setName(String sName) {
        this.name = sName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setLabel(String sLabel) {
        super.setName(sLabel);
    }

    public String getLabel() {
        return super.getName();
    }

    public void setDomainFatherId(String sDomainFatherId) {
        this.domainFatherId = sDomainFatherId;
    }

    public String getDomainFatherId() {
        return this.domainFatherId;
    }

    public void setOrderNum(int iOrderNum) {
        this.order = iOrderNum;
    }

    public int getOrderNum() {
        return this.order;
    }

    public int getOrderPosition() {
        return this.getOrderNum();
    }

    public Date getCreationDate() {
        return this.createDate;
    }

    public void setCreationDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getRemovalDate() {
        return this.removeDate;
    }

    public void setRemovalDate(Date removeDate) {
        this.removeDate = removeDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public void setLastUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getRemoverUserId() {
        return this.removerUserId;
    }

    public void setRemoverUserId(String removerUserId) {
        this.removerUserId = removerUserId;
        this.remover = null;
    }

    public String getUpdaterUserId() {
        return this.updaterUserId;
    }

    public void setUpdaterUserId(String updaterUserId) {
        this.updaterUserId = updaterUserId;
        this.updater = null;
    }

    public int getNumProfileInst() {
        return this.profiles.size();
    }

    public void addProfileInst(ProfileInst profileInst) {
        this.profiles.add(profileInst);
    }

    public String getSpaceId() {
        return this.getDomainFatherId();
    }

    public void deleteProfileInst(ProfileInst profileInst) {
        this.profiles.removeIf(p -> p.getName().equals(profileInst.getName()));
    }

    public List<ProfileInst> getAllProfilesInst() {
        return List.copyOf(this.profiles);
    }

    public List<ProfileInst> getInheritedProfiles() {
        return this.profiles.stream().filter(BaseRightProfile::isInherited).collect(Collectors.toList());
    }

    public List<ProfileInst> getProfiles() {
        return this.profiles.stream().filter(Predicate.not(BaseRightProfile::isInherited)).collect(Collectors.toList());
    }

    public void removeAllProfilesInst() {
        this.profiles.clear();
    }

    public ProfileInst getProfileInst(String profileName) {
        return this.profiles.stream().filter(Predicate.not(BaseRightProfile::isInherited)).filter(p -> p.getName().equals(profileName)).findFirst().orElse(null);
    }

    public ProfileInst getInheritedProfileInst(String profileName) {
        return this.profiles.stream().filter(BaseRightProfile::isInherited).filter(p -> p.getName().equals(profileName)).findFirst().orElse(null);
    }

    public ProfileInst getProfileInst(int nIndex) {
        return this.profiles.get(nIndex);
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Parameter getParameter(String parameterName) {
        return this.parameters.stream().filter(p -> p.getName().equalsIgnoreCase(parameterName)).findFirst().orElse(null);
    }

    public String getParameterValue(String parameterName) {
        Parameter param = this.getParameter(parameterName);
        return param != null ? param.getValue() : "";
    }

    public String getLabel(String language) {
        return super.getName(language);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isInheritanceBlocked() {
        return this.isInheritanceBlocked;
    }

    public void setInheritanceBlocked(boolean isInheritanceBlocked) {
        this.isInheritanceBlocked = isInheritanceBlocked;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
        this.creator = null;
    }

    public User getCreator() {
        if (this.creator == null && StringUtil.isDefined((String)this.creatorUserId)) {
            this.creator = UserDetail.getById(this.creatorUserId);
        }
        return this.creator;
    }

    public User getLastUpdater() {
        if (this.updater == null && StringUtil.isDefined((String)this.updaterUserId)) {
            this.updater = UserDetail.getById(this.updaterUserId);
        }
        return this.updater;
    }

    public void removeInheritedProfiles() {
        this.profiles.removeIf(BaseRightProfile::isInherited);
    }

    public boolean isWorkflow() {
        return WAComponent.getByName(this.getName()).orElseThrow(() -> new SilverpeasRuntimeException("No Such WAComponent " + this.getName())).isWorkflow();
    }

    public boolean isTopicTracker() {
        return WAComponent.getByName(this.getName()).orElseThrow(() -> new SilverpeasRuntimeException("No Such WAComponent " + this.getName())).isTopicTracker();
    }

    public String getPermalink() {
        return URLUtil.getSimpleURL(1, this.getId());
    }

    public Collection<SilverpeasRole> getSilverpeasRolesFor(User user) {
        Set silverpeasRoles = SilverpeasRole.fromStrings((String[])OrganizationController.get().getUserProfiles(user.getId(), this.getId()));
        silverpeasRoles.remove(SilverpeasRole.MANAGER);
        return silverpeasRoles;
    }

    public boolean isRemoved() {
        return STATUS_REMOVED.equals(this.getStatus());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentInst that = (ComponentInst)o;
        return this.id.equals(that.id) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }
}

