/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.resources;

import edu.psu.swe.scim.spec.annotation.ScimAttribute;
import edu.psu.swe.scim.spec.annotation.ScimResourceType;
import edu.psu.swe.scim.spec.resources.Address;
import edu.psu.swe.scim.spec.resources.Email;
import edu.psu.swe.scim.spec.resources.Entitlement;
import edu.psu.swe.scim.spec.resources.Im;
import edu.psu.swe.scim.spec.resources.Name;
import edu.psu.swe.scim.spec.resources.PhoneNumber;
import edu.psu.swe.scim.spec.resources.Photo;
import edu.psu.swe.scim.spec.resources.Role;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.resources.X509Certificate;
import edu.psu.swe.scim.spec.schema.ResourceReference;
import edu.psu.swe.scim.spec.schema.Schema;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ScimResourceType(id="User", name="User", schema="urn:ietf:params:scim:schemas:core:2.0:User", description="Top level ScimUser", endpoint="/Users")
@XmlRootElement(name="User")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ScimUser
extends ScimResource
implements Serializable {
    private static final long serialVersionUID = -2306547717245071997L;
    public static final String RESOURCE_NAME = "User";
    public static final String SCHEMA_URI = "urn:ietf:params:scim:schemas:core:2.0:User";
    @XmlElement
    @ScimAttribute(description="A Boolean value indicating the User's administrative status.")
    Boolean active = true;
    @XmlElement
    @ScimAttribute(description="A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.")
    List<Address> addresses;
    @XmlElement
    @ScimAttribute(description="The name of the User, suitable for display to end-users. The name SHOULD be the full name of the User being described if known")
    String displayName;
    @XmlElement
    @ScimAttribute(description="E-mail addresses for the user. The value SHOULD be canonicalized by the Service Provider, e.g. bjensen@example.com instead of bjensen@EXAMPLE.COM. Canonical Type values of work, home, and other.")
    List<Email> emails;
    @XmlElement
    @ScimAttribute(description="Get the description")
    List<Entitlement> entitlements;
    @XmlElement
    @ScimAttribute(description="A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated")
    List<ResourceReference> groups;
    @XmlElement
    @ScimAttribute(description="Instant messaging address for the User.")
    List<Im> ims;
    @XmlElement
    @ScimAttribute(description="Used to indicate the User's default location for purposes of localizing items such as currency, date time format, numerical representations, etc.")
    String locale;
    @XmlElement
    @ScimAttribute(description="The components of the user's real name. Providers MAY return just the full name as a single string in the formatted sub-attribute, or they MAY return just the individual component attributes using the other sub-attributes, or they MAY return both. If both variants are returned, they SHOULD be describing the same name, with the formatted name indicating how the component attributes should be combined.")
    Name name;
    @XmlElement
    @ScimAttribute(description="The casual way to address the user in real life, e.g.'Bob' or 'Bobby' instead of 'Robert'. This attribute SHOULD NOT be used to represent a User's username (e.g. bjensen or mpepperidge)")
    String nickName;
    @XmlElement
    @ScimAttribute(returned=Schema.Attribute.Returned.NEVER, description="The User's clear text password.  This attribute is intended to be used as a means to specify an initial password when creating a new User or to reset an existing User's password.")
    String password;
    @XmlElement
    @ScimAttribute(description="Phone numbers for the User.  The value SHOULD be canonicalized by the Service Provider according to format in RFC3966 e.g. 'tel:+1-201-555-0123'.  Canonical Type values of work, home, mobile, fax, pager and other.")
    List<PhoneNumber> phoneNumbers;
    @XmlElement
    @ScimAttribute(description="URLs of photos of the User.")
    List<Photo> photos;
    @XmlElement
    @ScimAttribute(description="A fully qualified URL to a page representing the User's online profile", referenceTypes={"external"})
    String profileUrl;
    @XmlElement
    @ScimAttribute(description="Indicates the User's preferred written or spoken language.  Generally used for selecting a localized User interface. e.g., 'en_US' specifies the language English and country US.")
    String preferredLanguage;
    @XmlElement
    @ScimAttribute(description="A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.")
    List<Role> roles;
    @XmlElement
    @ScimAttribute(description="The User's time zone in the 'Olson' timezone database format; e.g.,'America/Los_Angeles'")
    String timezone;
    @XmlElement
    @ScimAttribute(description="The user's title, such as \"Vice President.\"")
    String title;
    @XmlElement
    @ScimAttribute(required=true, uniqueness=Schema.Attribute.Uniqueness.SERVER, description="Unique identifier for the User typically used by the user to directly authenticate to the service provider. Each User MUST include a non-empty userName value.  This identifier MUST be unique across the Service Consumer's entire set of Users.  REQUIRED")
    String userName;
    @XmlElement
    @ScimAttribute(description="Used to identify the organization to user relationship. Typical values used might be 'Contractor', 'Employee', 'Intern', 'Temp', 'External', and 'Unknown' but any value may be used.")
    String userType;
    @XmlElement
    @ScimAttribute(description="A list of certificates issued to the User.")
    List<X509Certificate> x509Certificates;

    public ScimUser() {
        super(SCHEMA_URI);
    }

    @Override
    public String getResourceType() {
        return RESOURCE_NAME;
    }

    public Optional<Address> getPrimaryAddress() {
        if (this.addresses == null) {
            return Optional.empty();
        }
        return this.addresses.stream().filter(Address::getPrimary).findFirst();
    }

    public Optional<Email> getPrimaryEmailAddress() {
        if (this.emails == null) {
            return Optional.empty();
        }
        return this.emails.stream().filter(Email::getPrimary).findFirst();
    }

    public Optional<PhoneNumber> getPrimaryPhoneNumber() {
        if (this.phoneNumbers == null) {
            return Optional.empty();
        }
        return this.phoneNumbers.stream().filter(PhoneNumber::getPrimary).findFirst();
    }

    public Boolean getActive() {
        return this.active;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public List<Entitlement> getEntitlements() {
        return this.entitlements;
    }

    public List<ResourceReference> getGroups() {
        return this.groups;
    }

    public List<Im> getIms() {
        return this.ims;
    }

    public String getLocale() {
        return this.locale;
    }

    public Name getName() {
        return this.name;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getPassword() {
        return this.password;
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public List<Photo> getPhotos() {
        return this.photos;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserType() {
        return this.userType;
    }

    public List<X509Certificate> getX509Certificates() {
        return this.x509Certificates;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    public void setEntitlements(List<Entitlement> entitlements) {
        this.entitlements = entitlements;
    }

    public void setGroups(List<ResourceReference> groups) {
        this.groups = groups;
    }

    public void setIms(List<Im> ims) {
        this.ims = ims;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public void setPhotos(List<Photo> photos) {
        this.photos = photos;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public void setX509Certificates(List<X509Certificate> x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    @Override
    public String toString() {
        return "ScimUser(super=" + super.toString() + ", active=" + this.getActive() + ", addresses=" + this.getAddresses() + ", displayName=" + this.getDisplayName() + ", emails=" + this.getEmails() + ", entitlements=" + this.getEntitlements() + ", groups=" + this.getGroups() + ", ims=" + this.getIms() + ", locale=" + this.getLocale() + ", name=" + this.getName() + ", nickName=" + this.getNickName() + ", phoneNumbers=" + this.getPhoneNumbers() + ", photos=" + this.getPhotos() + ", profileUrl=" + this.getProfileUrl() + ", preferredLanguage=" + this.getPreferredLanguage() + ", roles=" + this.getRoles() + ", timezone=" + this.getTimezone() + ", title=" + this.getTitle() + ", userName=" + this.getUserName() + ", userType=" + this.getUserType() + ", x509Certificates=" + this.getX509Certificates() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScimUser)) {
            return false;
        }
        ScimUser other = (ScimUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        List<Address> this$addresses = this.getAddresses();
        List<Address> other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !((Object)this$addresses).equals(other$addresses)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<Email> this$emails = this.getEmails();
        List<Email> other$emails = other.getEmails();
        if (this$emails == null ? other$emails != null : !((Object)this$emails).equals(other$emails)) {
            return false;
        }
        List<Entitlement> this$entitlements = this.getEntitlements();
        List<Entitlement> other$entitlements = other.getEntitlements();
        if (this$entitlements == null ? other$entitlements != null : !((Object)this$entitlements).equals(other$entitlements)) {
            return false;
        }
        List<ResourceReference> this$groups = this.getGroups();
        List<ResourceReference> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        List<Im> this$ims = this.getIms();
        List<Im> other$ims = other.getIms();
        if (this$ims == null ? other$ims != null : !((Object)this$ims).equals(other$ims)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        String this$nickName = this.getNickName();
        String other$nickName = other.getNickName();
        if (this$nickName == null ? other$nickName != null : !this$nickName.equals(other$nickName)) {
            return false;
        }
        List<PhoneNumber> this$phoneNumbers = this.getPhoneNumbers();
        List<PhoneNumber> other$phoneNumbers = other.getPhoneNumbers();
        if (this$phoneNumbers == null ? other$phoneNumbers != null : !((Object)this$phoneNumbers).equals(other$phoneNumbers)) {
            return false;
        }
        List<Photo> this$photos = this.getPhotos();
        List<Photo> other$photos = other.getPhotos();
        if (this$photos == null ? other$photos != null : !((Object)this$photos).equals(other$photos)) {
            return false;
        }
        String this$profileUrl = this.getProfileUrl();
        String other$profileUrl = other.getProfileUrl();
        if (this$profileUrl == null ? other$profileUrl != null : !this$profileUrl.equals(other$profileUrl)) {
            return false;
        }
        String this$preferredLanguage = this.getPreferredLanguage();
        String other$preferredLanguage = other.getPreferredLanguage();
        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
            return false;
        }
        List<Role> this$roles = this.getRoles();
        List<Role> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$userType = this.getUserType();
        String other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        List<X509Certificate> this$x509Certificates = this.getX509Certificates();
        List<X509Certificate> other$x509Certificates = other.getX509Certificates();
        return !(this$x509Certificates == null ? other$x509Certificates != null : !((Object)this$x509Certificates).equals(other$x509Certificates));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScimUser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        List<Address> $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : ((Object)$addresses).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<Email> $emails = this.getEmails();
        result = result * 59 + ($emails == null ? 43 : ((Object)$emails).hashCode());
        List<Entitlement> $entitlements = this.getEntitlements();
        result = result * 59 + ($entitlements == null ? 43 : ((Object)$entitlements).hashCode());
        List<ResourceReference> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        List<Im> $ims = this.getIms();
        result = result * 59 + ($ims == null ? 43 : ((Object)$ims).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        String $nickName = this.getNickName();
        result = result * 59 + ($nickName == null ? 43 : $nickName.hashCode());
        List<PhoneNumber> $phoneNumbers = this.getPhoneNumbers();
        result = result * 59 + ($phoneNumbers == null ? 43 : ((Object)$phoneNumbers).hashCode());
        List<Photo> $photos = this.getPhotos();
        result = result * 59 + ($photos == null ? 43 : ((Object)$photos).hashCode());
        String $profileUrl = this.getProfileUrl();
        result = result * 59 + ($profileUrl == null ? 43 : $profileUrl.hashCode());
        String $preferredLanguage = this.getPreferredLanguage();
        result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
        List<Role> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        List<X509Certificate> $x509Certificates = this.getX509Certificates();
        result = result * 59 + ($x509Certificates == null ? 43 : ((Object)$x509Certificates).hashCode());
        return result;
    }
}

