/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.spnego;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import javax.security.auth.login.LoginException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.silverpeas.spnego.SpnegoHttpURLConnection;

public class SpnegoSOAPConnection
extends SOAPConnection {
    private final transient SpnegoHttpURLConnection conn;

    public SpnegoSOAPConnection(String loginModuleName) throws LoginException {
        this.conn = new SpnegoHttpURLConnection(loginModuleName);
    }

    public SpnegoSOAPConnection(GSSCredential creds) {
        this(creds, true);
    }

    public SpnegoSOAPConnection(GSSCredential creds, boolean dispose) {
        this.conn = new SpnegoHttpURLConnection(creds, dispose);
    }

    public SpnegoSOAPConnection(String loginModuleName, String username, String password) throws LoginException {
        this.conn = new SpnegoHttpURLConnection(loginModuleName, username, password);
    }

    public final SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        SOAPMessage message = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            MimeHeaders headers = request.getMimeHeaders();
            String[] contentType = headers.getHeader("Content-Type");
            String[] soapAction = headers.getHeader("SOAPAction");
            if (null == contentType) {
                StringBuilder header = new StringBuilder();
                if (null == soapAction) {
                    header.append("application/soap+xml; charset=UTF-8;");
                } else {
                    header.append("text/xml; charset=UTF-8;");
                }
                this.conn.addRequestProperty("Content-Type", header.toString());
            } else {
                if (contentType.length > 1) {
                    throw new IllegalArgumentException("Content-Type defined more than once.");
                }
                this.conn.addRequestProperty("Content-Type", contentType[0]);
            }
            if (null != soapAction) {
                if (soapAction.length > 1) {
                    throw new IllegalArgumentException("SOAPAction defined more than once.");
                }
                this.conn.addRequestProperty("SOAPAction", soapAction[0]);
            }
            request.writeTo((OutputStream)bos);
            this.conn.connect(new URL(endpoint.toString()), bos);
            MessageFactory factory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            try {
                message = factory.createMessage(null, this.conn.getInputStream());
            }
            catch (IOException e) {
                message = factory.createMessage(null, this.conn.getErrorStream());
            }
        }
        catch (MalformedURLException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (GSSException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (PrivilegedActionException e) {
            throw new SOAPException((Throwable)e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ioe) {}
            this.close();
        }
        return message;
    }

    public final void close() {
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }
}

