/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.silverpeas.components.forums.model.ForumPath;
import org.silverpeas.components.forums.model.Message;
import org.silverpeas.core.util.ContributionPath;
import org.silverpeas.kernel.util.Pair;

public class MessagePath
extends ContributionPath<Message> {
    private static final long serialVersionUID = 6399724102076584647L;
    private final ForumPath forumPath;

    public MessagePath(ForumPath forumPath, @Nonnull Collection<Message> c) {
        super(c);
        this.forumPath = forumPath;
    }

    protected boolean isRoot(Message message) {
        return message.isSubject();
    }

    protected String getLabel(Message message, String language) {
        return message.getTitle();
    }

    public String format(String language, boolean fullSpacePath) {
        return this.forumPath.format(language, fullSpacePath) + this.formatMessagePath(language);
    }

    private String formatMessagePath(String language) {
        Pair lastPath;
        String currentResourceIdPath = this.stream().map(Message::getIdAsString).collect(Collectors.joining(","));
        if (!currentResourceIdPath.equals((lastPath = this.lastPathByLanguage.computeIfAbsent(language, l -> Pair.of((Object)"", (Object)""))).getFirst())) {
            StringBuilder result = new StringBuilder();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Message message = (Message)iterator.next();
                result.insert(0, " > " + this.getLabel(message, language));
            }
            lastPath = Pair.of((Object)currentResourceIdPath, (Object)result.toString());
            this.lastPathByLanguage.put(language, lastPath);
        }
        return (String)lastPath.getSecond();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

