/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.TableGenerator;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.ClassifyValue;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValue;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.kernel.util.StringUtil;

@Entity
public class PdcPosition
implements Serializable {
    private static final long serialVersionUID = 665144316569539208L;
    @Id
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="PdcPosition", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    private Long id;
    @ManyToMany(fetch=FetchType.EAGER)
    @NotNull
    @Size(min=1)
    @Valid
    private @NotNull @Size(min=1) @Valid Set<PdcAxisValue> axisValues = new HashSet<PdcAxisValue>();

    public PdcPosition() {
    }

    public String getId() {
        if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    public PdcPosition withId(String id) {
        if (StringUtil.isDefined((String)id)) {
            this.id = Long.valueOf(id);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    public Set<PdcAxisValue> getValues() {
        return this.axisValues;
    }

    public PdcPosition withValue(PdcAxisValue value) {
        this.axisValues.add(value);
        return this;
    }

    public PdcPosition withValues(Collection<PdcAxisValue> values) {
        this.axisValues.addAll(values);
        return this;
    }

    protected PdcPosition copy() {
        PdcPosition position = new PdcPosition();
        for (PdcAxisValue aValue : this.axisValues) {
            position.getValues().add(aValue.copy());
        }
        return position;
    }

    protected PdcPosition(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdcPosition that = (PdcPosition)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.axisValues, that.axisValues);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.axisValues);
    }

    public String toString() {
        return "PdcPosition{id=" + this.id + ", axisValues=" + String.valueOf(this.axisValues) + "}";
    }

    public ClassifyPosition toClassifyPosition() throws PdcException {
        ClassifyPosition position = new ClassifyPosition((List<ClassifyValue>)new ArrayList<ClassifyValue>());
        if (this.getId() != null) {
            position.setPositionId(Integer.parseInt(this.getId()));
        }
        for (PdcAxisValue pdcAxisValue : this.getValues()) {
            position.getValues().add(pdcAxisValue.toClassifyValue());
        }
        return position;
    }

    public Set<PdcAxisValue> getValuesOfAxis(String axisId) {
        HashSet<PdcAxisValue> valuesOfTheAxis = new HashSet<PdcAxisValue>();
        for (PdcAxisValue pdcAxisValue : this.getValues()) {
            if (!pdcAxisValue.getAxisId().equals(axisId)) continue;
            valuesOfTheAxis.add(pdcAxisValue);
        }
        return valuesOfTheAxis;
    }
}

