/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.interests.service;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.pdc.interests.model.Interests;
import org.silverpeas.core.pdc.interests.service.InterestsService;
import org.silverpeas.core.util.ServiceProvider;

public class InterestsManager {
    @Inject
    private InterestsService interestsService;

    public static final InterestsManager getInstance() {
        return (InterestsManager)ServiceProvider.getService(InterestsManager.class, (Annotation[])new Annotation[0]);
    }

    protected InterestsManager() {
    }

    public List<Interests> getInterestsByUserId(int userId) {
        return this.interestsService.getInterestsByUserId(userId);
    }

    public Interests getInterestsById(int id) {
        return this.interestsService.getInterestsById(id);
    }

    public int isInterestsExists(String interestsName, int userId) {
        List<Interests> icList = this.getInterestsByUserId(userId);
        for (Interests ic : icList) {
            if (!interestsName.equals(ic.getName())) continue;
            return ic.getId();
        }
        return -1;
    }

    public int createInterests(Interests interests) {
        int id = this.isInterestsExists(interests.getName(), interests.getOwnerID());
        if (id != -1) {
            this.interestsService.removeInterestsById(id);
        }
        return this.interestsService.createInterests(interests);
    }
}

