/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.search;

import edu.psu.swe.scim.server.filter.FilterLexer;
import edu.psu.swe.scim.server.filter.FilterParser;
import edu.psu.swe.scim.spec.protocol.filter.ExpressionBuildingListener;
import edu.psu.swe.scim.spec.protocol.filter.FilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.FilterParseException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filter {
    private static final Logger log = LoggerFactory.getLogger(Filter.class);
    private FilterExpression expression;
    private String filter;

    protected Filter() {
    }

    public Filter(String filter) throws FilterParseException {
        log.debug("Creating a filter - {}", (Object)filter);
        this.setFilter(filter);
    }

    public Filter(FilterExpression filterExpression) {
        log.debug("Creating a filter - {}", (Object)filterExpression);
        this.expression = filterExpression;
        this.filter = filterExpression.toString();
    }

    public void setFilter(String filter) throws FilterParseException {
        this.filter = filter;
        this.expression = this.parseFilter(filter);
    }

    protected FilterExpression parseFilter(String filter) throws FilterParseException {
        FilterLexer l = new FilterLexer((CharStream)new ANTLRInputStream(filter));
        FilterParser p = new FilterParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.setBuildParseTree(true);
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + ":" + charPositionInLine + " due to " + msg, (Throwable)e);
            }
        });
        try {
            FilterParser.FilterContext tree = p.filter();
            ExpressionBuildingListener expListener = new ExpressionBuildingListener();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)expListener, (ParseTree)tree);
            return expListener.getFilterExpression();
        }
        catch (IllegalStateException e) {
            throw new FilterParseException("Failed to parse filter: " + filter, e);
        }
    }

    public String toString() {
        return this.expression.toFilter();
    }

    public FilterExpression getExpression() {
        return this.expression;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FilterExpression this$expression = this.getExpression();
        FilterExpression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Filter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterExpression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }
}

