/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service;

import com.sun.portal.container.ContainerLogger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class ServiceFinder {
    private static Logger logger = ContainerLogger.getLogger(ServiceFinder.class, "CLogMessages");
    private static final String META_INF_SERVICES = "META-INF/services/";

    ServiceFinder() {
    }

    public static Object getServiceImplementationInstance(String serviceName) throws Exception {
        Object implObject;
        String serviceEntry = ServiceFinder.getServiceImplementationName(serviceName);
        if (serviceEntry != null) {
            Class<?> implementationClass = Thread.currentThread().getContextClassLoader().loadClass(serviceEntry);
            implObject = implementationClass.newInstance();
        } else {
            implObject = null;
        }
        return implObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServiceImplementationName(String serviceName) {
        String result;
        block24: {
            String fullServiceName = META_INF_SERVICES + serviceName;
            result = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                return result;
            }
            InputStream input = null;
            BufferedReader reader = null;
            try {
                input = loader.getResourceAsStream(fullServiceName);
                if (input == null) break block24;
                try {
                    reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                }
                catch (Exception e) {
                    reader = new BufferedReader(new InputStreamReader(input));
                }
                result = reader.readLine();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "PSC_CSPCS010", new String[]{serviceName, result});
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.SEVERE)) {
                    LogRecord logRecord = new LogRecord(Level.SEVERE, "PSC_CSPCS017");
                    logRecord.setLoggerName(logger.getName());
                    logRecord.setParameters(new String[]{fullServiceName});
                    logRecord.setThrown(ex);
                    logger.log(logRecord);
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return result;
    }
}

