/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.client.Debug;
import com.novell.ldap.controls.LDAPSortKey;

public class LDAPSortControl
extends LDAPControl {
    private static int ORDERING_RULE = 0;
    private static int REVERSE_ORDER = 1;
    private static String requestOID = "1.2.840.113556.1.4.473";
    private static String responseOID = "1.2.840.113556.1.4.474";

    public LDAPSortControl(LDAPSortKey key, boolean critical) {
        this(new LDAPSortKey[]{key}, critical);
    }

    public LDAPSortControl(LDAPSortKey[] keys, boolean critical) {
        super(requestOID, critical, null);
        ASN1SequenceOf sortKeyList = new ASN1SequenceOf();
        for (int i = 0; i < keys.length; ++i) {
            ASN1Sequence key = new ASN1Sequence();
            key.add(new ASN1OctetString(keys[i].getKey()));
            if (keys[i].getMatchRule() != null) {
                key.add(new ASN1Tagged(new ASN1Identifier(2, false, ORDERING_RULE), new ASN1OctetString(keys[i].getMatchRule()), false));
            }
            if (keys[i].getReverse()) {
                key.add(new ASN1Tagged(new ASN1Identifier(2, false, REVERSE_ORDER), new ASN1Boolean(true), false));
            }
            sortKeyList.add(key);
        }
        this.setValue(sortKeyList.getEncoding(new LBEREncoder()));
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("com.novell.ldap.controls.LDAPSortResponse"));
            Debug.trace("Controls", "Registered Sort Control Response Class");
        }
        catch (ClassNotFoundException e) {
            Debug.trace("Controls", "Could not register Sort Control Response - Class not found");
        }
    }
}

