/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.FullGcNodeBin;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoFullGcNodeBin;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MongoFullGcNodeBinSumBsonSize
implements FullGcNodeBin {
    private static final Logger LOG = LoggerFactory.getLogger(MongoFullGcNodeBinSumBsonSize.class);
    private final MongoFullGcNodeBin delegate;
    private final MongoDocumentStore store;

    public MongoFullGcNodeBinSumBsonSize(MongoFullGcNodeBin delegate) {
        this.delegate = delegate;
        this.store = delegate.getMongoDocumentStore();
    }

    @Override
    public void setEnabled(boolean value) {
        this.delegate.setEnabled(value);
    }

    @Override
    public List<NodeDocument> findAndUpdate(List<UpdateOp> updateOpList) {
        List<String> ids = updateOpList.stream().map(UpdateOp::getId).collect(Collectors.toList());
        long initialBsonSize = this.getBsonSize(ids);
        LOG.debug("bson size before update: {}", (Object)initialBsonSize);
        List<NodeDocument> updated = this.delegate.findAndUpdate(updateOpList);
        if (!updated.isEmpty()) {
            long afterUpdateBsonSize = this.getBsonSize(ids);
            LOG.debug("bson size after update: {}", (Object)afterUpdateBsonSize);
            if (initialBsonSize > 0L && afterUpdateBsonSize > 0L) {
                this.addBsonSize(initialBsonSize - afterUpdateBsonSize);
            }
        }
        return updated;
    }

    @Override
    public int remove(Map<String, Long> orphanOrDeletedRemovalMap) {
        long bsonSize = this.getBsonSize(new ArrayList<String>(orphanOrDeletedRemovalMap.keySet()));
        LOG.debug("bson size before remove: {}", (Object)bsonSize);
        int removed = this.delegate.remove(orphanOrDeletedRemovalMap);
        if (removed > 0 && bsonSize > 0L) {
            this.addBsonSize(bsonSize);
        }
        return removed;
    }

    private void addBsonSize(long bsonSize) {
        if (bsonSize <= 0L) {
            LOG.warn("bson size {} is not positive", (Object)bsonSize);
            return;
        }
        Bson query = Filters.eq((String)"_id", (Object)"versionGC");
        Bson update = Updates.inc((String)"fullGcRemovedTotalBsonSize", (Number)bsonSize);
        this.store.getDBCollection(Collection.SETTINGS).updateOne(query, update);
        LOG.info("Incremented bson size with {}", (Object)bsonSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBsonSize(List<String> ids) {
        long start = System.currentTimeMillis();
        try {
            Bson match = Filters.in((String)"_id", ids);
            BasicDBObject first = (BasicDBObject)this.store.getDBCollection(Collection.NODES).aggregate(List.of(new BasicDBObject("$match", (Object)match), new BasicDBObject("$group", (Object)new BasicDBObject("_id", null).append("totalSize", (Object)new BasicDBObject("$sum", (Object)new BasicDBObject("$bsonSize", (Object)"$$ROOT")))))).first();
            long l = first != null ? first.getLong("totalSize") : -1L;
            return l;
        }
        finally {
            LOG.info("getBsonSize for {} documents took {} ms", (Object)ids.size(), (Object)(System.currentTimeMillis() - start));
        }
    }
}

