/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class NodeDocumentRevisionCleaner {
    private final DocumentNodeStore documentNodeStore;
    private final NodeDocument workingDocument;
    private final RevisionPropertiesClassifier revisionClassifier;
    private final RevisionCleanerUtility revisionCleaner;
    private long toModifiedMs;

    public NodeDocumentRevisionCleaner(DocumentNodeStore documentNodeStore, NodeDocument workingDocument) {
        this(documentNodeStore, workingDocument, Instant.now().minus(24L, ChronoUnit.HOURS).toEpochMilli());
    }

    public NodeDocumentRevisionCleaner(DocumentNodeStore documentNodeStore, NodeDocument workingDocument, long toModifiedMs) {
        this.workingDocument = workingDocument;
        this.documentNodeStore = documentNodeStore;
        this.toModifiedMs = toModifiedMs;
        this.revisionClassifier = new RevisionPropertiesClassifier(workingDocument);
        this.revisionCleaner = new RevisionCleanerUtility(this.revisionClassifier);
    }

    public void collectOldRevisions(UpdateOp op) {
        this.revisionClassifier.classifyRevisionsAndProperties();
        this.revisionCleaner.preserveRevisionsNewerThanThreshold(this.toModifiedMs);
        this.revisionCleaner.preserveLastRevisionForEachProperty();
        this.revisionCleaner.preserveRevisionsReferencedByCheckpoints();
        this.revisionCleaner.removeCandidatesInList();
        for (Map.Entry<Integer, TreeSet<Revision>> entry : this.revisionCleaner.getCandidateRevisionsToClean().entrySet()) {
            for (Revision revision : entry.getValue()) {
                RevisionVector sweepRevisions;
                TreeSet properties = (TreeSet)this.revisionClassifier.getPropertiesModifiedByRevision().get(revision);
                if (properties != null) {
                    block2: for (String property : properties) {
                        Map<UpdateOp.Key, UpdateOp.Operation> c = op.getChanges();
                        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> e : c.entrySet()) {
                            if (!e.getKey().equals(new UpdateOp.Key(property, null)) || e.getValue().type != UpdateOp.Operation.Type.REMOVE) continue;
                            continue block2;
                        }
                        op.removeMapEntry(property, revision);
                    }
                }
                boolean newerThanSweep = (sweepRevisions = this.documentNodeStore.getSweepRevisions()) == null ? false : sweepRevisions.isRevisionNewer(revision);
                boolean isBC = this.workingDocument.getLocalBranchCommits().contains(revision);
                if (newerThanSweep || isBC) continue;
                op.removeMapEntry("_revisions", revision);
            }
        }
    }

    protected SortedMap<String, SortedMap<Integer, TreeSet<Revision>>> getRevisionsModifyingPropertyByCluster() {
        return this.revisionClassifier.getRevisionsModifyingPropertyByCluster();
    }

    protected SortedMap<String, TreeSet<Revision>> getRevisionsModifyingProperty() {
        return this.revisionClassifier.getRevisionsModifyingProperty();
    }

    protected SortedMap<Revision, TreeSet<String>> getPropertiesModifiedByRevision() {
        return this.revisionClassifier.getPropertiesModifiedByRevision();
    }

    public SortedMap<Integer, TreeSet<Revision>> getBlockedRevisionsToKeep() {
        return this.revisionCleaner.getBlockedRevisionsToKeep();
    }

    public SortedMap<Integer, TreeSet<Revision>> getCandidateRevisionsToClean() {
        return this.revisionCleaner.getCandidateRevisionsToClean();
    }

    protected void classifyRevisionsAndProperties() {
        this.revisionClassifier.classifyRevisionsAndProperties();
    }

    protected void markLastRevisionForEachProperty() {
        this.revisionCleaner.preserveLastRevisionForEachProperty();
    }

    protected void markRevisionsNewerThanThresholdToPreserve(long amount, ChronoUnit unit) {
        this.revisionCleaner.preserveRevisionsNewerThanThreshold(amount, unit);
    }

    protected void markCheckpointRevisionsToPreserve() {
        this.revisionCleaner.preserveRevisionsReferencedByCheckpoints();
    }

    protected void removeCandidatesInList() {
        this.revisionCleaner.removeCandidatesInList();
    }

    private class RevisionCleanerUtility {
        private final SortedMap<Integer, TreeSet<Revision>> blockedRevisionsToKeep;
        private final SortedMap<Integer, TreeSet<Revision>> candidateRevisionsToClean;
        private final RevisionPropertiesClassifier revisionClassifier;

        private RevisionCleanerUtility(RevisionPropertiesClassifier revisionClassifier) {
            this.revisionClassifier = revisionClassifier;
            this.candidateRevisionsToClean = new TreeMap<Integer, TreeSet<Revision>>();
            this.blockedRevisionsToKeep = new TreeMap<Integer, TreeSet<Revision>>();
        }

        private void preserveLastRevisionForEachProperty() {
            for (SortedMap<Integer, TreeSet<Revision>> revisionsByCluster : this.revisionClassifier.getRevisionsModifyingPropertyByCluster().values()) {
                for (TreeSet<Revision> revisions : revisionsByCluster.values()) {
                    Revision lastRevision = revisions.last();
                    this.addBlockedRevisionToKeep(lastRevision);
                }
            }
        }

        private void preserveRevisionsNewerThanThreshold(long amount, ChronoUnit unit) {
            long thresholdToPreserve = Instant.now().minus(amount, unit).toEpochMilli();
            this.preserveRevisionsNewerThanThreshold(thresholdToPreserve);
        }

        private void preserveRevisionsNewerThanThreshold(long thresholdToPreserve) {
            for (TreeSet<Revision> revisionSet : this.candidateRevisionsToClean.values()) {
                for (Revision revision : revisionSet) {
                    if (revision.getTimestamp() <= thresholdToPreserve) continue;
                    this.addBlockedRevisionToKeep(revision);
                }
            }
        }

        private void preserveRevisionsReferencedByCheckpoints() {
            SortedMap<Revision, Checkpoints.Info> checkpoints = NodeDocumentRevisionCleaner.this.documentNodeStore.getCheckpoints().getCheckpoints();
            checkpoints.forEach((revision, info) -> this.revisionClassifier.getRevisionsModifyingProperty().forEach((propertyName, revisionsSet) -> info.getCheckpoint().forEach(revisionToFind -> {
                if (revisionsSet.contains(revisionToFind)) {
                    this.addBlockedRevisionToKeep((Revision)revisionToFind);
                } else {
                    Revision previousRevision = revisionsSet.descendingSet().ceiling((Revision)revisionToFind);
                    if (previousRevision != null) {
                        this.addBlockedRevisionToKeep(previousRevision);
                    }
                }
            })));
        }

        private void addCandidateRevisionToClean(Revision revision) {
            this.candidateRevisionsToClean.computeIfAbsent(revision.getClusterId(), key -> new TreeSet<Revision>(StableRevisionComparator.INSTANCE)).add(revision);
        }

        private void addBlockedRevisionToKeep(Revision revision) {
            this.blockedRevisionsToKeep.computeIfAbsent(revision.getClusterId(), key -> new TreeSet<Revision>(StableRevisionComparator.INSTANCE)).add(revision);
        }

        private void removeCandidatesInList() {
            NodeDocumentRevisionCleaner.this.revisionCleaner.blockedRevisionsToKeep.forEach((key, value) -> {
                if (NodeDocumentRevisionCleaner.this.revisionCleaner.getCandidateRevisionsToClean().containsKey(key)) {
                    ((TreeSet)NodeDocumentRevisionCleaner.this.revisionCleaner.getCandidateRevisionsToClean().get(key)).removeAll((Collection<?>)value);
                }
            });
        }

        public SortedMap<Integer, TreeSet<Revision>> getBlockedRevisionsToKeep() {
            return this.blockedRevisionsToKeep;
        }

        public SortedMap<Integer, TreeSet<Revision>> getCandidateRevisionsToClean() {
            return this.candidateRevisionsToClean;
        }
    }

    private class RevisionPropertiesClassifier {
        private final NodeDocument workingDocument;
        private SortedMap<String, SortedMap<Integer, TreeSet<Revision>>> revisionsModifyingPropertyByCluster;
        private SortedMap<String, TreeSet<Revision>> revisionsModifyingProperty;
        private SortedMap<Revision, TreeSet<String>> propertiesModifiedByRevision;

        private RevisionPropertiesClassifier(NodeDocument workingDocument) {
            this.workingDocument = workingDocument;
            this.revisionsModifyingPropertyByCluster = new TreeMap<String, SortedMap<Integer, TreeSet<Revision>>>();
            this.revisionsModifyingProperty = new TreeMap<String, TreeSet<Revision>>();
            this.propertiesModifiedByRevision = new TreeMap<Revision, TreeSet<String>>(StableRevisionComparator.INSTANCE);
        }

        private void classifyRevisionsAndProperties() {
            SortedMap<Revision, String> deletedRevisions = this.workingDocument.getLocalDeleted();
            if (!deletedRevisions.isEmpty()) {
                Revision createdRevision = deletedRevisions.firstKey();
                NodeDocumentRevisionCleaner.this.revisionCleaner.addBlockedRevisionToKeep(createdRevision);
            }
            SortedMap<Revision, String> documentRevisions = this.workingDocument.getLocalRevisions();
            for (Map.Entry<Revision, String> revisionEntry : documentRevisions.entrySet()) {
                Revision revision = revisionEntry.getKey();
                String revisionValue = revisionEntry.getValue();
                if (!Utils.isCommitted(revisionValue)) continue;
                NodeDocumentRevisionCleaner.this.revisionCleaner.addCandidateRevisionToClean(revision);
                this.classifyPropertiesModifiedByRevision(revision);
            }
        }

        private void classifyPropertiesModifiedByRevision(Revision revision) {
            for (Map.Entry<String, Object> propertyEntry : this.workingDocument.entrySet()) {
                Map valueMap;
                if (!Utils.isPropertyName(propertyEntry.getKey()) && !NodeDocument.isDeletedEntry(propertyEntry.getKey()) || !(valueMap = (Map)propertyEntry.getValue()).containsKey(revision)) continue;
                this.propertiesModifiedByRevision.computeIfAbsent(revision, key -> new TreeSet()).add(propertyEntry.getKey());
                this.revisionsModifyingPropertyByCluster.computeIfAbsent(propertyEntry.getKey(), key -> new TreeMap()).computeIfAbsent(revision.getClusterId(), key -> new TreeSet<Revision>(StableRevisionComparator.INSTANCE)).add(revision);
                this.revisionsModifyingProperty.computeIfAbsent(propertyEntry.getKey(), key -> new TreeSet<Revision>(StableRevisionComparator.INSTANCE)).add(revision);
            }
        }

        public SortedMap<String, SortedMap<Integer, TreeSet<Revision>>> getRevisionsModifyingPropertyByCluster() {
            return this.revisionsModifyingPropertyByCluster;
        }

        public SortedMap<String, TreeSet<Revision>> getRevisionsModifyingProperty() {
            return this.revisionsModifyingProperty;
        }

        public SortedMap<Revision, TreeSet<String>> getPropertiesModifiedByRevision() {
            return this.propertiesModifiedByRevision;
        }
    }
}

