/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.password;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.security.authentication.password.rule.PasswordRule;
import org.silverpeas.core.security.authentication.password.service.PasswordRulesServiceProvider;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.password.AbstractPasswordResource;
import org.silverpeas.core.webapi.password.PasswordCheckEntity;
import org.silverpeas.core.webapi.password.PasswordEntity;
import org.silverpeas.core.webapi.password.PasswordPolicyEntity;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@WebService
@Path(value="password")
@Authenticated
public class PasswordResource
extends AbstractPasswordResource {
    protected static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.password.settings.password");
    protected static int nbMatchingCombinedRules = settings.getInteger("password.combination.nbMatchingRules", 0);

    protected String getResourceBasePath() {
        return "password";
    }

    public void validateUserAuthentication(UserPrivilegeValidation validation) throws WebApplicationException {
        block2: {
            try {
                super.validateUserAuthentication(validation);
            }
            catch (WebApplicationException wae) {
                if (Response.Status.UNAUTHORIZED.getStatusCode() == wae.getResponse().getStatus()) break block2;
                throw wae;
            }
        }
    }

    @GET
    @Path(value="policy")
    @Produces(value={"application/json", "application/xml"})
    public PasswordPolicyEntity getPolicy() {
        try {
            PasswordPolicyEntity passwordPolicy = PasswordPolicyEntity.createFrom(nbMatchingCombinedRules, PasswordRulesServiceProvider.getPasswordRulesService().getExtraRuleMessage(this.getLanguage()));
            for (PasswordRule rule : PasswordRulesServiceProvider.getPasswordRulesService().getRequiredRules()) {
                passwordPolicy.addRule(this.asWebEntity(rule));
            }
            for (PasswordRule rule : PasswordRulesServiceProvider.getPasswordRulesService().getCombinedRules()) {
                passwordPolicy.addCombinedRule(this.asWebEntity(rule));
            }
            return passwordPolicy;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Path(value="policy/checking")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PasswordCheckEntity checking(PasswordEntity password) {
        return this.asWebEntity(PasswordRulesServiceProvider.getPasswordRulesService().check(password.getValue()));
    }
}

