/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.selection;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.img;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.SpaceWithSubSpacesAndComponents;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;

public class BasketSelectionUI {
    private BasketSelectionUI() {
    }

    public static String getPutIntoBasketSelectionHtmlSnippet(String callback, String userLanguage) {
        if (BasketSelectionUI.displayPutIntoBasketSelectionShortcut()) {
            img basketImg = new img(URLUtil.getApplicationURL() + "/util/icons/add-basket.png");
            a basketLink = new a();
            basketLink.setTitle(ResourceLocator.getGeneralLocalizationBundle((String)userLanguage).getString("GML.putInBasket"));
            basketLink.setClass("add-to-basket-selection");
            basketLink.setHref("javascript:void(0)");
            basketLink.setOnClick(callback);
            basketLink.addElement((Element)basketImg);
            return basketLink.toString();
        }
        return "";
    }

    public static boolean displayPutIntoBasketSelectionShortcut() {
        SimpleCache cache = CacheAccessorProvider.getSessionCacheAccessor().getCache();
        String key = "displayPutIntoBasketSelectionShortcut@" + User.getCurrentUser().getId();
        return Objects.requireNonNull((Boolean)cache.computeIfAbsent((Object)key, Boolean.class, BasketSelectionUI::computeDisplayPutIntoBasketSelectionShortcut));
    }

    private static boolean computeDisplayPutIntoBasketSelectionShortcut() {
        SpaceWithSubSpacesAndComponents fullTreeview;
        OrganizationController controller = OrganizationController.get();
        String userId = User.getCurrentUser().getId();
        try {
            fullTreeview = controller.getFullTreeviewOnComponentName(userId, "infoLetter");
        }
        catch (AdminException e) {
            SilverLogger.getLogger(BasketSelectionUI.class).warn((Throwable)e);
            return false;
        }
        List newslettersInstances = fullTreeview.componentInstanceSelector().fromAllSpaces().select();
        return controller.getUserProfilesByComponentId(userId, (Collection)newslettersInstances.stream().map(Identifiable::getId).collect(Collectors.toList())).values().stream().flatMap(Collection::stream).anyMatch(p -> Optional.ofNullable(SilverpeasRole.fromString((String)p)).filter(r -> r.isGreaterThanOrEquals(SilverpeasRole.PUBLISHER)).isPresent());
    }
}

