/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.security.authentication.verifier.UserMustAcceptTermsOfServiceVerifier;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class TermsOfServiceResponseHandler
extends CredentialsFunctionHandler {
    @Override
    public String getFunction() {
        return "TermsOfServiceResponse";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doAction(HttpServletRequest request) {
        HttpRequest httpRequest = (HttpRequest)request;
        String tosToken = httpRequest.getParameter("tosToken");
        if (StringUtil.isDefined((String)tosToken)) {
            UserMustAcceptTermsOfServiceVerifier verifier = AuthenticationUserVerifierFactory.getUserMustAcceptTermsOfServiceVerifier((String)tosToken);
            if (verifier.getUser() == null) {
                return this.getErrorDestination("Error_UserTosTimeout");
            }
            try {
                boolean tosAccepted = httpRequest.getParameterAsBoolean("tosAccepted");
                if (!tosAccepted) {
                    String string = this.getErrorDestination("Error_UserTosRefused");
                    return string;
                }
                try {
                    this.getAdminService().userAcceptsTermsOfService(verifier.getUser().getId());
                }
                catch (AdminException e) {
                    SilverLogger.getLogger((Object)this).error("terms of service error with login {0}", (Object[])new String[]{verifier.getUser().getLogin()}, (Throwable)e);
                    String string = this.getErrorDestination(AuthenticationResponse.Status.UNKNOWN_FAILURE.getCode());
                    verifier.clearCache();
                    return string;
                }
                request.setAttribute("internalAuthToken", (Object)CacheAccessorProvider.getApplicationCacheAccessor().getCache().add((Object)verifier.getUser()));
                request.setAttribute("skipTermsOfServiceAcceptance", (Object)true);
                String string = "/AuthenticationServlet";
                return string;
            }
            finally {
                verifier.clearCache();
            }
        }
        return this.getErrorDestination(AuthenticationResponse.Status.UNKNOWN_FAILURE.getCode());
    }

    private String getErrorDestination(String errorCode) {
        return "/Login?ErrorCode=" + errorCode;
    }
}

