/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.wildfly.clustering.marshalling.Externalizer;

public interface EntryVersionExternalizer<V extends EntryVersion>
extends Externalizer<V> {

    public static class SimpleClusteredVersionExternalizer
    implements EntryVersionExternalizer<SimpleClusteredVersion> {
        public void writeObject(ObjectOutput output, SimpleClusteredVersion version) throws IOException {
            output.writeInt(version.getTopologyId());
            output.writeLong(version.getVersion());
        }

        public SimpleClusteredVersion readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new SimpleClusteredVersion(input.readInt(), input.readLong());
        }

        public Class<SimpleClusteredVersion> getTargetClass() {
            return SimpleClusteredVersion.class;
        }
    }

    public static class NumericVersionExternalizer
    implements EntryVersionExternalizer<NumericVersion> {
        public void writeObject(ObjectOutput output, NumericVersion version) throws IOException {
            output.writeLong(version.getVersion());
        }

        public NumericVersion readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new NumericVersion(input.readLong());
        }

        public Class<NumericVersion> getTargetClass() {
            return NumericVersion.class;
        }
    }
}

