/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import org.jboss.as.clustering.context.ContextClassLoaderReference;
import org.jboss.as.clustering.context.ContextReference;
import org.jboss.as.clustering.context.ContextReferenceExecutor;
import org.jboss.as.clustering.context.Contextualizer;
import org.jgroups.util.ThreadFactory;

public class ClassLoaderThreadFactory
implements ThreadFactory {
    private final ThreadFactory factory;
    private final ClassLoader targetLoader;
    private final Contextualizer contextualizer;

    public ClassLoaderThreadFactory(ThreadFactory factory, ClassLoader targetLoader) {
        this.factory = factory;
        this.targetLoader = targetLoader;
        this.contextualizer = new ContextReferenceExecutor((Object)targetLoader, (ContextReference)ContextClassLoaderReference.INSTANCE);
    }

    public Thread newThread(Runnable runner) {
        return this.newThread(runner, null);
    }

    public Thread newThread(Runnable runner, String name) {
        Thread thread = this.factory.newThread(this.contextualizer.contextualize(runner), name);
        ContextClassLoaderReference.INSTANCE.accept(thread, this.targetLoader);
        return thread;
    }

    public void setPattern(String pattern) {
        this.factory.setPattern(pattern);
    }

    public void setIncludeClusterName(boolean includeClusterName) {
        this.factory.setIncludeClusterName(includeClusterName);
    }

    public void setClusterName(String channelName) {
        this.factory.setClusterName(channelName);
    }

    public void setAddress(String address) {
        this.factory.setAddress(address);
    }

    public void renameThread(String base_name, Thread thread) {
        this.factory.renameThread(base_name, thread);
    }
}

