/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.util.Objects;
import org.wildfly.common.Assert;

public class EJBModuleIdentifier
implements Serializable {
    private static final long serialVersionUID = 6743739852843753760L;
    private final String appName;
    private final String moduleName;
    private final String distinctName;
    private transient int hashCode;

    public EJBModuleIdentifier(String appName, String moduleName, String distinctName) {
        Assert.checkNotNullParam((String)"appName", (Object)appName);
        Assert.checkNotNullParam((String)"moduleName", (Object)moduleName);
        Assert.checkNotEmptyParam((String)"moduleName", (String)moduleName);
        Assert.checkNotNullParam((String)"distinctName", (Object)distinctName);
        this.appName = appName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
    }

    public EJBModuleIdentifier(String appName, String moduleName) {
        this(appName, moduleName, "");
    }

    public EJBModuleIdentifier(String moduleName) {
        this("", moduleName);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public boolean equals(Object other) {
        return other instanceof EJBModuleIdentifier && this.equals((EJBModuleIdentifier)other);
    }

    public boolean equals(EJBModuleIdentifier other) {
        return other != null && (other == this || other.hashCode() == this.hashCode() && Objects.equals(this.appName, other.appName) && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.distinctName, other.distinctName));
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode != 0) {
            return hashCode;
        }
        hashCode = Objects.hashCode(this.appName) + 13 * (Objects.hashCode(this.moduleName) + 13 * Objects.hashCode(this.distinctName));
        this.hashCode = hashCode == 0 ? 1 : hashCode;
        return this.hashCode;
    }

    public String toString() {
        String distinctName = this.getDistinctName();
        if (distinctName == null || distinctName.isEmpty()) {
            return String.format("%s/%s", this.getAppName(), this.getModuleName());
        }
        return String.format("%s/%s/%s", this.getAppName(), this.getModuleName(), distinctName);
    }
}

