/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.common.function.Functions;

public class ValueMarshaller<T>
implements ProtoStreamMarshaller<T> {
    private final Class<T> targetClass;
    private final Supplier<T> factory;

    public ValueMarshaller(T value) {
        this(Functions.constantSupplier(value));
    }

    public ValueMarshaller(Supplier<T> factory) {
        this.targetClass = factory.get().getClass();
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            reader.skipField(tag);
        }
        return this.factory.get();
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T value) {
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

