/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.io.Serializable;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.ExtendedCallback;

public final class PasswordResetCallback
implements ExtendedCallback,
Serializable {
    private static final long serialVersionUID = -8789058459408593766L;
    private final String prompt;
    private char[] password;

    public PasswordResetCallback(String prompt) {
        Assert.checkNotNullParam("prompt", prompt);
        Assert.checkNotEmptyParam("prompt", prompt);
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public char[] getPassword() {
        char[] password = this.password;
        return password == null ? null : (char[])password.clone();
    }

    public void setPassword(char[] password) {
        this.password = password == null ? null : (char[])password.clone();
    }

    public void clearPassword() {
        char[] password = this.password;
        if (password != null) {
            Arrays.fill(password, ' ');
        }
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }
}

