/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ear.spec;

import java.util.HashMap;
import java.util.Map;
import org.jboss.metadata.merge.javaee.spec.JavaEEVersion;

public enum EarVersion {
    UNKNOWN(null, null, JavaEEVersion.UNKNOWN),
    APP_1_3("http://java.sun.com/dtd/application_1_3.dtd", "1.3", JavaEEVersion.UNKNOWN),
    APP_1_4("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd", "1.4", JavaEEVersion.V1_4),
    APP_5_0("http://java.sun.com/xml/ns/javaee/application_5.xsd", "5.0", JavaEEVersion.V5),
    APP_6_0("http://java.sun.com/xml/ns/javaee/application_6.xsd", "6.0", JavaEEVersion.V6),
    APP_7_0("http://xmlns.jcp.org/xml/ns/javaee/application_7.xsd", "7.0", JavaEEVersion.V7),
    APP_8_0("http://xmlns.jcp.org/xml/ns/javaee/application_8.xsd", "8.0", JavaEEVersion.V8),
    APP_9_0("https://jakarta.ee/xml/ns/jakartaee/application_9.xsd", "9.0", JavaEEVersion.V9);

    private static final Map<String, EarVersion> bindings;
    private final String location;
    private final String version;
    private final JavaEEVersion javaEEVersion;

    private EarVersion(String location, String version, JavaEEVersion javaEEVersion) {
        this.location = location;
        this.version = version;
        this.javaEEVersion = javaEEVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public JavaEEVersion getJavaEEVersion() {
        return this.javaEEVersion;
    }

    public static EarVersion forLocation(String location) {
        EarVersion version = bindings.get(location);
        return version != null ? version : UNKNOWN;
    }

    static {
        bindings = new HashMap<String, EarVersion>();
        for (EarVersion version : EarVersion.values()) {
            bindings.put(version.location, version);
        }
    }
}

