/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelJoin<T>
extends Flowable<T> {
    final ParallelFlowable<? extends T> source;
    final int prefetch;
    final boolean delayErrors;

    public ParallelJoin(ParallelFlowable<? extends T> source, int prefetch, boolean delayErrors) {
        this.source = source;
        this.prefetch = prefetch;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        JoinSubscriptionBase parent = this.delayErrors ? new JoinSubscriptionDelayError<T>(s, this.source.parallelism(), this.prefetch) : new JoinSubscription<T>(s, this.source.parallelism(), this.prefetch);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class JoinInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 8410034718427740355L;
        final JoinSubscriptionBase<T> parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile SimplePlainQueue<T> queue;

        JoinInnerSubscriber(JoinSubscriptionBase<T> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce(this, s, this.prefetch);
        }

        public void onNext(T t) {
            this.parent.onNext(this, t);
        }

        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        public void onComplete() {
            this.parent.onComplete();
        }

        public void requestOne() {
            long p = this.produced + 1L;
            if (p == (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }

        public void request(long n) {
            long p = this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }

        public boolean cancel() {
            return SubscriptionHelper.cancel(this);
        }

        SimplePlainQueue<T> getQueue() {
            SimplePlainQueue<T> q = this.queue;
            if (q == null) {
                this.queue = q = new SpscArrayQueue<T>(this.prefetch);
            }
            return q;
        }
    }

    static final class JoinSubscriptionDelayError<T>
    extends JoinSubscriptionBase<T> {
        private static final long serialVersionUID = -5737965195918321883L;

        JoinSubscriptionDelayError(Subscriber<? super T> actual, int n, int prefetch) {
            super(actual, n, prefetch);
        }

        @Override
        void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    SimplePlainQueue<T> q = inner.getQueue();
                    if (!q.offer(value)) {
                        inner.cancel();
                        this.errors.addThrowable(new MissingBackpressureException("Queue full?!"));
                        this.done.decrementAndGet();
                        this.drainLoop();
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q = inner.getQueue();
                if (!q.offer(value) && inner.cancel()) {
                    this.errors.addThrowable(new MissingBackpressureException("Queue full?!"));
                    this.done.decrementAndGet();
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        void onError(Throwable e) {
            this.errors.addThrowable(e);
            this.done.decrementAndGet();
            this.drain();
        }

        @Override
        void onComplete() {
            this.done.decrementAndGet();
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber[] s = this.subscribers;
            int n = s.length;
            Subscriber a = this.downstream;
            while (true) {
                int w;
                SimplePlainQueue q;
                JoinInnerSubscriber inner;
                int i;
                boolean empty;
                boolean d;
                long r = this.requested.get();
                long e = 0L;
                block1: while (e != r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    d = this.done.get() == 0;
                    empty = true;
                    for (i = 0; i < n; ++i) {
                        Object v;
                        inner = s[i];
                        q = inner.queue;
                        if (q == null || (v = q.poll()) == null) continue;
                        empty = false;
                        a.onNext(v);
                        inner.requestOne();
                        if (++e == r) break block1;
                    }
                    if (d && empty) {
                        Throwable ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            a.onError(this.errors.terminate());
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    d = this.done.get() == 0;
                    empty = true;
                    for (i = 0; i < n; ++i) {
                        inner = s[i];
                        q = inner.queue;
                        if (q == null || q.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d && empty) {
                        Throwable ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            a.onError(this.errors.terminate());
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }

    static final class JoinSubscription<T>
    extends JoinSubscriptionBase<T> {
        private static final long serialVersionUID = 6312374661811000451L;

        JoinSubscription(Subscriber<? super T> actual, int n, int prefetch) {
            super(actual, n, prefetch);
        }

        @Override
        public void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    SimplePlainQueue<T> q = inner.getQueue();
                    if (!q.offer(value)) {
                        this.cancelAll();
                        MissingBackpressureException mbe = new MissingBackpressureException("Queue full?!");
                        if (this.errors.compareAndSet(null, mbe)) {
                            this.downstream.onError((Throwable)mbe);
                        } else {
                            RxJavaPlugins.onError(mbe);
                        }
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q = inner.getQueue();
                if (!q.offer(value)) {
                    this.cancelAll();
                    this.onError(new MissingBackpressureException("Queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable e) {
            if (this.errors.compareAndSet(null, e)) {
                this.cancelAll();
                this.drain();
            } else if (e != this.errors.get()) {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.done.decrementAndGet();
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber[] s = this.subscribers;
            int n = s.length;
            Subscriber a = this.downstream;
            while (true) {
                int w;
                SimplePlainQueue q;
                JoinInnerSubscriber inner;
                int i;
                boolean empty;
                boolean d;
                Throwable ex;
                long r = this.requested.get();
                long e = 0L;
                block1: while (e != r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = (Throwable)this.errors.get();
                    if (ex != null) {
                        this.cleanup();
                        a.onError(ex);
                        return;
                    }
                    d = this.done.get() == 0;
                    empty = true;
                    for (i = 0; i < s.length; ++i) {
                        Object v;
                        inner = s[i];
                        q = inner.queue;
                        if (q == null || (v = q.poll()) == null) continue;
                        empty = false;
                        a.onNext(v);
                        inner.requestOne();
                        if (++e == r) break block1;
                    }
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = (Throwable)this.errors.get();
                    if (ex != null) {
                        this.cleanup();
                        a.onError(ex);
                        return;
                    }
                    d = this.done.get() == 0;
                    empty = true;
                    for (i = 0; i < n; ++i) {
                        inner = s[i];
                        q = inner.queue;
                        if (q == null || q.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }

    static abstract class JoinSubscriptionBase<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 3100232009247827843L;
        final Subscriber<? super T> downstream;
        final JoinInnerSubscriber<T>[] subscribers;
        final AtomicThrowable errors = new AtomicThrowable();
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger done = new AtomicInteger();

        JoinSubscriptionBase(Subscriber<? super T> actual, int n, int prefetch) {
            this.downstream = actual;
            JoinInnerSubscriber[] a = new JoinInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new JoinInnerSubscriber(this, prefetch);
            }
            this.subscribers = a;
            this.done.lazySet(n);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    this.cleanup();
                }
            }
        }

        void cancelAll() {
            for (JoinInnerSubscriber<T> s : this.subscribers) {
                s.cancel();
            }
        }

        void cleanup() {
            for (JoinInnerSubscriber<T> s : this.subscribers) {
                s.queue = null;
            }
        }

        abstract void onNext(JoinInnerSubscriber<T> var1, T var2);

        abstract void onError(Throwable var1);

        abstract void onComplete();

        abstract void drain();
    }
}

