/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importCalendar.importOutlook;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class SilverOutlookItemsList {
    private ActiveXComponent activexOutlook;
    private Dispatch oOutlook;
    private Dispatch namespace;
    private Dispatch folder;
    private Dispatch itemsList;

    protected abstract int getOlFolder();

    protected abstract String getOlItem();

    public Dispatch getFolder() {
        return this.folder;
    }

    public void setFolder(Dispatch folder) {
        this.folder = folder;
    }

    public Dispatch getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Dispatch namespace) {
        this.namespace = namespace;
    }

    public ActiveXComponent getActivexOutlook() {
        return this.activexOutlook;
    }

    public void setActivexOutlook(ActiveXComponent ax) {
        this.activexOutlook = ax;
    }

    public Dispatch getOOutlook() {
        return this.oOutlook;
    }

    public void setOOutlook(Dispatch olo) {
        this.oOutlook = olo;
    }

    public void initWithCurrentOutlook() {
        this.setActivexOutlook(new ActiveXComponent("Outlook.Application"));
        this.setOOutlook(this.getActivexOutlook().getObject());
        this.setNamespace(Dispatch.call(this.getOOutlook(), "GetNamespace", (Object)"MAPI").toDispatch());
        this.setFolder(Dispatch.call(this.getNamespace(), "GetDefaultFolder", (Object)new Integer(this.getOlFolder())).toDispatch());
    }

    public void loadItemsList(int nbDaysBefore) {
        Dispatch allItems = Dispatch.get(this.getFolder(), "Items").toDispatch();
        String filter = this.createFilter(nbDaysBefore);
        this.setItemsList(Dispatch.call(allItems, "Restrict", (Object)filter).toDispatch());
    }

    private String createFilter(int nbDays) {
        Date today = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        cal.add(6, -nbDays);
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy 00:00 a");
        return "[Start] >= '" + format.format(cal.getTime()) + "'";
    }

    protected Dispatch createNewItem() {
        return Dispatch.invoke(this.getOOutlook(), "CreateItem", 2, new Object[]{this.getOlItem()}, new int[1]).toDispatch();
    }

    public Dispatch getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(Dispatch list) {
        this.itemsList = list;
    }

    public int getItemsListCount() {
        return Dispatch.call(this.getItemsList(), "Count").getInt();
    }
}

