/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.tree.impl.HiddenTree;
import org.apache.jackrabbit.oak.plugins.tree.impl.OrderedChildnameIterator;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTree
implements Tree {
    private static final String[] INTERNAL_NODE_NAMES = new String[]{":index", ":references", ":weakreferences", ":conflict"};

    @NotNull
    protected abstract AbstractTree createChild(@NotNull String var1) throws IllegalArgumentException;

    @Nullable
    protected abstract AbstractTree getParentOrNull();

    @NotNull
    protected abstract NodeBuilder getNodeBuilder();

    protected boolean isHidden(@NotNull String name) {
        return NodeStateUtils.isHidden((String)name);
    }

    @NotNull
    protected String[] getInternalNodeNames() {
        return INTERNAL_NODE_NAMES;
    }

    @NotNull
    public NodeState getNodeState() {
        return this.getNodeBuilder().getNodeState();
    }

    protected boolean hasOrderableChildren() {
        return this.getNodeBuilder().hasProperty(":childOrder");
    }

    @NotNull
    protected Iterable<String> getChildNames() {
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        PropertyState order = nodeBuilder.getProperty(":childOrder");
        if (order != null && order.getType() == Type.NAMES) {
            return IteratorUtils.toIterable((Iterator)new OrderedChildnameIterator((Iterable)order.getValue(Type.NAMES), nodeBuilder.getChildNodeNames()));
        }
        return nodeBuilder.getChildNodeNames();
    }

    public String toString() {
        return this.toString(5);
    }

    /*
     * WARNING - void declaration
     */
    private String toString(int childNameCountLimit) {
        void var4_6;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPath()).append(": ");
        sb.append('{');
        for (PropertyState propertyState : this.getProperties()) {
            sb.append(' ').append(propertyState).append(',');
        }
        Iterator<String> names = this.getChildNames().iterator();
        boolean bl = false;
        while (names.hasNext() && ++var4_6 <= childNameCountLimit) {
            sb.append(' ').append(names.next()).append(" = { ... },");
        }
        if (names.hasNext()) {
            sb.append(" ...");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean isRoot() {
        return this.getParentOrNull() == null;
    }

    @NotNull
    public String getPath() {
        if (this.isRoot()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder(128);
        this.buildPath(sb);
        return sb.toString();
    }

    protected void buildPath(@NotNull StringBuilder sb) {
        AbstractTree parent = this.getParentOrNull();
        if (parent != null) {
            parent.buildPath(sb);
            sb.append('/').append(this.getName());
        }
    }

    @NotNull
    public Tree.Status getStatus() {
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        if (nodeBuilder.isNew() || nodeBuilder.isReplaced()) {
            return Tree.Status.NEW;
        }
        if (nodeBuilder.isModified()) {
            return Tree.Status.MODIFIED;
        }
        return Tree.Status.UNCHANGED;
    }

    public boolean exists() {
        return this.getNodeBuilder().exists() && !this.isHidden(this.getName());
    }

    @NotNull
    public AbstractTree getParent() {
        AbstractTree parent = this.getParentOrNull();
        Validate.checkState((parent != null ? 1 : 0) != 0, (Object)"root tree does not have a parent");
        return parent;
    }

    @NotNull
    public Tree getChild(@NotNull String name) throws IllegalArgumentException {
        if (!this.isHidden(name)) {
            return this.createChild(name);
        }
        return new HiddenTree(this, name);
    }

    @Nullable
    public PropertyState getProperty(@NotNull String name) {
        return !this.isHidden(name) ? this.getNodeBuilder().getProperty(name) : null;
    }

    public boolean hasProperty(@NotNull String name) {
        return !this.isHidden(name) && this.getNodeBuilder().hasProperty(name);
    }

    public long getPropertyCount() {
        return IterableUtils.size(this.getProperties());
    }

    @Nullable
    public Tree.Status getPropertyStatus(@NotNull String name) {
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        if (!this.hasProperty(name)) {
            return null;
        }
        if (nodeBuilder.isNew(name)) {
            return Tree.Status.NEW;
        }
        if (nodeBuilder.isReplaced(name)) {
            return Tree.Status.MODIFIED;
        }
        return Tree.Status.UNCHANGED;
    }

    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return IterableUtils.filter((Iterable)this.getNodeBuilder().getProperties(), propertyState -> !this.isHidden(propertyState.getName()));
    }

    public boolean hasChild(@NotNull String name) {
        return this.getNodeBuilder().hasChildNode(name) && !this.isHidden(name);
    }

    public long getChildrenCount(long max) {
        String[] internalNodeNames = this.getInternalNodeNames();
        int len = internalNodeNames.length;
        max = max + (long)len < 0L ? Long.MAX_VALUE : (max += (long)len);
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        long count = nodeBuilder.getChildNodeCount(max);
        if (count > 0L) {
            for (String name : internalNodeNames) {
                if (!nodeBuilder.hasChildNode(name)) continue;
                --count;
            }
        }
        return count;
    }

    @NotNull
    public Iterable<Tree> getChildren() {
        Iterable children = IterableUtils.transform(this.getChildNames(), name -> {
            AbstractTree child = this.createChild((String)name);
            return child.exists() ? child : null;
        });
        return IterableUtils.filter((Iterable)children, Objects::nonNull);
    }
}

