/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;

final class RootNodeDefinition
implements NodeDefinition {
    private static final String REP_ROOT = "rep:root";
    private final NodeTypeManager ntManager;

    RootNodeDefinition(NodeTypeManager ntManager) {
        this.ntManager = ntManager;
    }

    public NodeType[] getRequiredPrimaryTypes() {
        try {
            return new NodeType[]{this.ntManager.getNodeType(REP_ROOT)};
        }
        catch (RepositoryException e) {
            return new NodeType[0];
        }
    }

    public String[] getRequiredPrimaryTypeNames() {
        return new String[]{REP_ROOT};
    }

    public NodeType getDefaultPrimaryType() {
        try {
            return this.ntManager.getNodeType(REP_ROOT);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public String getDefaultPrimaryTypeName() {
        return REP_ROOT;
    }

    public boolean allowsSameNameSiblings() {
        return false;
    }

    public NodeType getDeclaringNodeType() {
        try {
            return this.ntManager.getNodeType(REP_ROOT);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public String getName() {
        return REP_ROOT;
    }

    public boolean isAutoCreated() {
        return true;
    }

    public boolean isMandatory() {
        return true;
    }

    public int getOnParentVersion() {
        return 2;
    }

    public boolean isProtected() {
        return false;
    }
}

