/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.notification;

import java.time.temporal.Temporal;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.notification.user.FallbackToCoreTemplatePathBehavior;
import org.silverpeas.core.notification.user.RemoveSenderRecipientBehavior;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.workflow.api.user.Replacement;

public abstract class AbstractReplacementNotificationBuilder
extends AbstractTemplateUserNotificationBuilder<Replacement>
implements RemoveSenderRecipientBehavior,
FallbackToCoreTemplatePathBehavior {
    private static final String MULTILANG_BUNDLE = "org.silverpeas.workflow.multilang.usernotification";
    private final NotifAction action;
    private final ComponentInst workflow;

    AbstractReplacementNotificationBuilder(Replacement resource, NotifAction action) {
        super((Object)resource);
        this.action = action;
        this.workflow = OrganizationController.get().getComponentInst(resource.getWorkflowInstanceId());
    }

    protected String getBundleSubjectKey() {
        return "notification.subject." + this.action.name().toLowerCase();
    }

    protected void performTemplateData(String language, Replacement resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getBundle(language).getStringWithParams(this.getBundleSubjectKey(), new Object[]{this.workflow.getName(language)}), null);
        String linkUrl = URLUtil.getCurrentServerURL() + URLUtil.getPermalink((URLUtil.Permalink)URLUtil.Permalink.COMPONENT, (String)resource.getWorkflowInstanceId());
        String linkLabel = this.getBundle(language).getStringWithParams("replacement.notifLinkLabel", new Object[]{this.workflow.getName(language)});
        this.getNotificationMetaData().setLink(new Link(linkUrl, linkLabel), language);
        template.setAttribute("incumbent", (Object)resource.getIncumbent().getFullName());
        template.setAttribute("substitute", (Object)resource.getSubstitute().getFullName());
        AbstractTemplateUserNotificationBuilder.NotificationTemporal startDate = new AbstractTemplateUserNotificationBuilder.NotificationTemporal(resource.getPeriod().getStartDate(), null, language);
        AbstractTemplateUserNotificationBuilder.NotificationTemporal endDate = new AbstractTemplateUserNotificationBuilder.NotificationTemporal((Temporal)TemporalConverter.asLocalDate((Temporal)resource.getPeriod().getEndDate()).minusDays(1L), null, language);
        template.setAttribute("start", (Object)startDate);
        if (!startDate.getDayDate().equals(endDate.getDayDate())) {
            template.setAttribute("end", (Object)endDate);
        }
    }

    protected void performNotificationResource(String language, Replacement resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setComponentInstanceId(resource.getWorkflowInstanceId());
        notificationResourceData.setResourceId(resource.getId());
    }

    protected String getTemplatePath() {
        return "workflow";
    }

    protected String getTemplateFileName() {
        return this.action.name().toLowerCase() + "Replacement";
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((Replacement)this.getResource()).getWorkflowInstanceId();
    }

    protected String getSender() {
        User sender = User.getCurrentRequester();
        if (sender == null) {
            sender = User.getMainAdministrator();
        }
        return sender.getId();
    }

    protected String getLocalizationBundlePath() {
        return MULTILANG_BUNDLE;
    }
}

