/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.util.SilverpeasListWrapper;

public class PaginationList<T>
extends SilverpeasListWrapper<T> {
    private static final IllegalArgumentException MORE_THAN_MAXSIZE_EXCEPTION = new IllegalArgumentException("No more than maxsize items can be added to this pagination");
    private final long maxsize;

    private PaginationList(List<T> aList) {
        this(aList, aList.size());
    }

    private PaginationList(List<T> aList, long maxItems) {
        super(aList);
        this.maxsize = maxItems;
    }

    public static <T> PaginationList<T> from(Collection<T> aCollection) {
        return new PaginationList<T>(new ArrayList<T>(aCollection));
    }

    public static <T> PaginationList<T> from(Collection<T> aCollection, long maxItems) {
        return new PaginationList<T>(new ArrayList<T>(aCollection), maxItems);
    }

    @Override
    public <U> SilverpeasList<U> newEmptyListWithSameProperties() {
        return new PaginationList(new ArrayList(this.size()), this.maxsize);
    }

    @Override
    public long originalListSize() {
        return this.maxsize;
    }

    @Override
    public boolean add(T e) {
        if ((long)(this.size() + 1) > this.originalListSize()) {
            throw MORE_THAN_MAXSIZE_EXCEPTION;
        }
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if ((long)(this.size() + c.size()) > this.originalListSize()) {
            throw MORE_THAN_MAXSIZE_EXCEPTION;
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if ((long)(this.size() + c.size()) > this.originalListSize()) {
            throw MORE_THAN_MAXSIZE_EXCEPTION;
        }
        return super.addAll(index, c);
    }

    @Override
    public void add(int index, T element) {
        if ((long)(this.size() + 1) > this.originalListSize()) {
            throw MORE_THAN_MAXSIZE_EXCEPTION;
        }
        super.add(index, element);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new PaginationListIterator(this, super.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new PaginationListIterator(this, super.listIterator(index));
    }

    private static class PaginationListIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> iterator;
        private final PaginationList<T> list;

        PaginationListIterator(PaginationList<T> list, ListIterator<T> iterator) {
            this.iterator = iterator;
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void set(T e) {
            this.iterator.set(e);
        }

        @Override
        public void add(T e) {
            if (this.list.originalListSize() + 1L > 0L) {
                throw MORE_THAN_MAXSIZE_EXCEPTION;
            }
            this.iterator.add(e);
        }
    }
}

