/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class AuthenticationResponse {
    private static final String ERROR_PREFIX = "Error_";
    private final Status status;
    private final String token;

    public static AuthenticationResponse succeed(String authToken) {
        return new AuthenticationResponse(authToken);
    }

    public static AuthenticationResponse error(Status errorStatus) {
        return new AuthenticationResponse(errorStatus);
    }

    AuthenticationResponse(String token) {
        this.status = Status.SUCCESS;
        this.token = token;
    }

    AuthenticationResponse(Status error) {
        this.status = error;
        this.token = "";
    }

    public Status getStatus() {
        return this.status;
    }

    public String getToken() {
        return this.token;
    }

    public String getMessage(String language) {
        return this.status.getMessage(language);
    }

    public static enum Status {
        SUCCESS(""),
        BAD_LOGIN_PASSWORD("Error_1"),
        BAD_LOGIN_PASSWORD_DOMAIN("Error_6"),
        UNKNOWN_FAILURE("Error_2"),
        NO_PASSWORD("Error_5"),
        PASSWORD_EXPIRED("Error_PwdExpired"),
        PASSWORD_TO_CHANGE("Error_PwdMustBeChanged"),
        PASSWORD_TO_CHANGE_ON_FIRST_LOGIN("Error_PwdMustBeChangedOnFirstLogin"),
        PASSWORD_EMAIL_TO_CHANGE_ON_FIRST_LOGIN("Error_PwdAndEmailMustBeChangedOnFirstLogin"),
        USER_ACCOUNT_BLOCKED("Error_UserAccountBlocked"),
        USER_ACCOUNT_DEACTIVATED("Error_UserAccountDeactivated");

        private final String key;

        private Status(String key) {
            this.key = key;
        }

        public boolean succeeded() {
            return this == SUCCESS;
        }

        public boolean isInError() {
            return !this.succeeded();
        }

        public boolean failed() {
            return !this.succeeded() && !this.rejected();
        }

        public boolean rejected() {
            return this == PASSWORD_EXPIRED || this == PASSWORD_EMAIL_TO_CHANGE_ON_FIRST_LOGIN || this == PASSWORD_TO_CHANGE || this == PASSWORD_TO_CHANGE_ON_FIRST_LOGIN;
        }

        public String getMessage(String language) {
            LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.authentication.multilang.authentication", (String)language);
            return messages.getString("authentication.logon." + this.key);
        }

        public String getCode() {
            return this.key;
        }

        public String toString() {
            return this.getCode();
        }
    }
}

