/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.constraint;

import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.persistence.datasource.constraint.OnlyByCreator;
import org.silverpeas.core.persistence.datasource.model.Entity;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class OnlyByCreatorValidator
implements ConstraintValidator<OnlyByCreator, Entity<?, ?>> {
    private String owner;

    public void initialize(OnlyByCreator constraintAnnotation) {
        this.owner = constraintAnnotation.owner();
    }

    public boolean isValid(Entity<?, ?> entity, ConstraintValidatorContext context) {
        Entity<?, ?> concerned;
        User requester = User.getCurrentRequester();
        if (requester != null && StringUtil.isDefined((String)(concerned = this.getConcernedEntity(entity)).getCreatorId())) {
            return requester.isAccessAdmin() || requester.getId().equals(concerned.getCreatorId());
        }
        return true;
    }

    private Entity<?, ?> getConcernedEntity(Entity<?, ?> entity) {
        Entity entityOwner;
        if (!this.owner.isEmpty()) {
            try {
                Field ownerField = entity.getClass().getDeclaredField(this.owner);
                ownerField.trySetAccessible();
                entityOwner = (Entity)ownerField.get(entity);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
            }
        } else {
            entityOwner = entity;
        }
        return entityOwner;
    }
}

