/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.notification.user.model.NotificationResourceDataDetails;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="st_notificationresource")
@NamedQuery(name="NotificationResourceData.deleteResources", query="delete from NotificationResourceData r where not exists (select d from DelayedNotificationData d where d.resource.id.id = r.id.id)")
public class NotificationResourceData
extends BasicJpaEntity<NotificationResourceData, UniqueLongIdentifier> {
    public static final String LOCATION_SEPARATOR = "@#@#@";
    private static final long serialVersionUID = -6720839869471833683L;
    private static final String EMPTY_JSON_DETAILS = "{}";
    private static final String TITLE_KEY = "title";
    private static final String DESCRIPTION_KEY = "description";
    private static final String LINK_KEY = "link";
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="resourceType", nullable=false)
    private String resourceType;
    @Column(name="resourceName", nullable=false)
    private String resourceName;
    @Column(name="resourceDescription")
    private String resourceDescription;
    @Column(name="resourceLocation", nullable=false)
    private String resourceLocation;
    @Column(name="resourceUrl")
    private String resourceUrl;
    @Column(name="componentInstanceId", nullable=false)
    private String componentInstanceId;
    @Column(name="attachmentTargetId")
    private String attachmentTargetId;
    @Column(name="resourceDetails")
    private String details;
    @Transient
    private transient NotificationResourceDataDetails transientDetails;
    @Transient
    private transient String currentLanguage = DisplayI18NHelper.getDefaultLanguage();

    public NotificationResourceData() {
    }

    public NotificationResourceData(NotificationResourceData notificationResourceData) {
        this.fillFrom(notificationResourceData);
    }

    public final void fillFrom(NotificationResourceData notificationResourceData) {
        this.resourceId = notificationResourceData.resourceId;
        this.resourceType = notificationResourceData.resourceType;
        this.resourceName = notificationResourceData.resourceName;
        this.resourceDescription = notificationResourceData.resourceDescription;
        this.resourceLocation = notificationResourceData.resourceLocation;
        this.resourceUrl = notificationResourceData.resourceUrl;
        this.getDetails().merge(notificationResourceData.transientDetails);
        this.componentInstanceId = notificationResourceData.componentInstanceId;
        this.attachmentTargetId = notificationResourceData.attachmentTargetId;
    }

    @Override
    protected void performBeforePersist() {
        super.performBeforePersist();
        this.forcesNullValues();
    }

    @Override
    protected void performBeforeUpdate() {
        this.forcesNullValues();
    }

    private void forcesNullValues() {
        if (StringUtils.isBlank((CharSequence)this.resourceDescription)) {
            this.resourceDescription = null;
        }
        if (StringUtils.isBlank((CharSequence)this.resourceUrl)) {
            this.resourceUrl = null;
        }
        String labels = this.transientDetails != null ? JSONCodec.encode(this.transientDetails) : null;
        this.details = StringUtil.defaultStringIfNotDefined((String)labels, null);
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.resourceId) && StringUtils.isNotBlank((CharSequence)this.resourceType) && StringUtils.isNotBlank((CharSequence)this.getResourceName()) && StringUtils.isNotBlank((CharSequence)this.resourceLocation) && StringUtils.isNotBlank((CharSequence)this.resourceUrl) && StringUtils.isNotBlank((CharSequence)this.componentInstanceId);
    }

    public void setId(Long id) {
        this.setId(id != null ? Long.toString(id) : null);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Number resourceId) {
        this.setResourceId((Object)resourceId);
    }

    public void setResourceId(String resourceId) {
        this.setResourceId((Object)resourceId);
    }

    private void setResourceId(Object resourceId) {
        this.resourceId = resourceId != null ? resourceId.toString() : null;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceName() {
        return this.getLocalizedDetail(TITLE_KEY, this.resourceName);
    }

    public void setResourceName(String resourceName) {
        this.resourceName = StringUtil.defaultStringIfNotDefined((String)this.setLocalizedDetail(TITLE_KEY, resourceName, this.resourceName));
    }

    public String getResourceDescription() {
        return this.getLocalizedDetail(DESCRIPTION_KEY, this.resourceDescription);
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = this.setLocalizedDetail(DESCRIPTION_KEY, resourceDescription, this.resourceDescription);
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public void setComponentInstanceId(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
    }

    public String getAttachmentTargetId() {
        return this.attachmentTargetId;
    }

    public void setAttachmentTargetId(String targetId) {
        this.attachmentTargetId = targetId;
    }

    public boolean isFeminineGender() {
        return this.getDetails().isFeminineGenderResource();
    }

    public void setFeminineGender(boolean gender) {
        this.getDetails().setFeminineGenderResource(gender);
    }

    public String getLinkLabel() {
        return this.getLocalizedDetail(LINK_KEY, "");
    }

    public void setLinkLabel(String linkLabel) {
        this.getDetails().putLocalized(this.currentLanguage, LINK_KEY, linkLabel);
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public void setCurrentLanguage(String currentLanguage) {
        this.currentLanguage = currentLanguage;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private NotificationResourceDataDetails getDetails() {
        if (this.transientDetails == null) {
            this.transientDetails = JSONCodec.decode(StringUtil.defaultStringIfNotDefined((String)this.details, (String)EMPTY_JSON_DETAILS), NotificationResourceDataDetails.class);
        }
        return this.transientDetails;
    }

    private String getLocalizedDetail(String localizedKey, String defaultData) {
        String localizedData = this.getDetails().getLocalized(this.currentLanguage, localizedKey);
        return StringUtil.defaultStringIfNotDefined((String)localizedData, (String)defaultData);
    }

    private String setLocalizedDetail(String localizedKey, String localizedData, String defaultData) {
        String result;
        if (DisplayI18NHelper.getDefaultLanguage().equals(this.currentLanguage)) {
            result = localizedData;
        } else {
            result = defaultData;
            this.getDetails().putLocalized(this.currentLanguage, localizedKey, localizedData);
        }
        return result;
    }
}

