/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.kernel.util.StringUtil;

public class NotificationContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = 341715544034127254L;
    public static final String COMPONENT_ID = "componentId";
    public static final String RESOURCE_ID = "resourceId";
    public static final String CONTRIBUTION_ID = "contributionId";
    public static final String PUBLICATION_ID = "publicationId";
    public static final String NODE_ID = "nodeId";
    public static final String RECIPIENT_USERS = "recipientUsers";
    public static final String RECIPIENT_GROUPS = "recipientGroups";
    public static final String MANUAL = "manual";
    private final User sender;

    public NotificationContext(User sender) {
        this.sender = sender;
    }

    public String getComponentId() {
        return this.get(COMPONENT_ID);
    }

    public String getResourceId() {
        return this.get(RESOURCE_ID);
    }

    public String getNodeId() {
        return this.get(NODE_ID);
    }

    public String getPublicationId() {
        return this.get(PUBLICATION_ID);
    }

    public String getContributionId() {
        return this.get(CONTRIBUTION_ID);
    }

    public String getTitle() {
        return this.get("title");
    }

    public String getContent() {
        return this.get("content");
    }

    public List<String> getAsList(String key) {
        String value = this.get(key);
        return Arrays.asList(StringUtils.split((String)value, (String)","));
    }

    public boolean getAsBoolean(String key) {
        String value = this.get(key);
        return StringUtil.getBooleanValue((String)value);
    }

    public User getSender() {
        return this.sender;
    }

    @Override
    public String get(Object key) {
        return (String)super.get(key);
    }

    public <T> T getObject(Object key) {
        return (T)super.get(key);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

