/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.date.TimeUnit;

@Embeddable
public class RecurrencePeriod
implements Serializable {
    @Column(name="recur_periodInterval", nullable=false)
    @NotNull
    private int interval;
    @Column(name="recur_periodUnit", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private TimeUnit timeUnit;

    protected RecurrencePeriod() {
    }

    private RecurrencePeriod(int every, TimeUnit unit) {
        this.interval = every;
        this.timeUnit = unit;
    }

    public static RecurrencePeriod every(int interval, TimeUnit unit) {
        if (unit.ordinal() < TimeUnit.DAY.ordinal()) {
            throw new IllegalArgumentException("The recurrence of an object planned in a calendar cannot be less than the day");
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("The recurrence of an object planned in a calendar cannot be less than every 1 of a given unit of time");
        }
        return new RecurrencePeriod(interval, unit);
    }

    public int getInterval() {
        return this.interval;
    }

    public TimeUnit getUnit() {
        return this.timeUnit;
    }

    public boolean isHourly() {
        return this.timeUnit == TimeUnit.HOUR;
    }

    public boolean isDaily() {
        return this.timeUnit == TimeUnit.DAY;
    }

    public boolean isWeekly() {
        return this.timeUnit == TimeUnit.WEEK;
    }

    public boolean isMonthly() {
        return this.timeUnit == TimeUnit.MONTH;
    }

    public boolean isYearly() {
        return this.timeUnit == TimeUnit.YEAR;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecurrencePeriod)) {
            return false;
        }
        RecurrencePeriod that = (RecurrencePeriod)o;
        if (this.interval != that.interval) {
            return false;
        }
        return this.timeUnit == that.timeUnit;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.interval).append((Object)this.timeUnit).toHashCode();
    }
}

