/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.util.Collection;
import java.util.List;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.importexport.control.GEDImportExport;
import org.silverpeas.core.importexport.control.ImportExportFactory;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.report.ImportReportManager;
import org.silverpeas.core.importexport.report.UnitReport;
import org.silverpeas.core.node.importexport.NodeTreeType;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.kernel.util.StringUtil;

public class NodeTreesTypeManager {
    public void processImport(UserDetail userDetail, List<NodeTreeType> listNodeTreeType, String targetComponentId, ImportReportManager reportManager) {
        int nbTopicTree = 1;
        int nbTopic = 1;
        GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, targetComponentId);
        if (!listNodeTreeType.isEmpty()) {
            for (NodeTreeType nodeTreeType : listNodeTreeType) {
                String componentId = !StringUtil.isDefined((String)nodeTreeType.getComponentId()) ? targetComponentId : nodeTreeType.getComponentId();
                gedIE.setCurrentComponentId(componentId);
                UnitReport unitReport = new UnitReport("<topicTree> #" + nbTopicTree);
                reportManager.addUnitReport(unitReport, componentId);
                ComponentInst component = OrganizationControllerProvider.getOrganisationController().getComponentInst(componentId);
                if (component == null) {
                    unitReport.setError(1);
                    unitReport.setStatus(3);
                    continue;
                }
                reportManager.setComponentName(componentId, component.getLabel());
                nbTopic = this.processImportNodeInternal(nodeTreeType.getNodeDetail(), null, gedIE, nbTopic, componentId, reportManager);
                ++nbTopicTree;
            }
        }
    }

    private int processImportNodeInternal(NodeDetail node, NodeDetail parentNode, GEDImportExport gedIE, int nbTopic, String componentId, ImportReportManager reportManager) {
        if (node != null) {
            Collection children;
            NodeDetail newNode;
            int parentNodeId;
            try {
                String parentNodeIdStr = parentNode != null ? parentNode.getNodePK().getId() : null;
                parentNodeId = parentNodeIdStr != null ? Integer.parseInt(parentNodeIdStr) : 0;
            }
            catch (NumberFormatException ex) {
                parentNodeId = 0;
            }
            UnitReport unitReport = new UnitReport("<topic> #" + nbTopic);
            reportManager.addUnitReport(unitReport, componentId);
            try {
                newNode = gedIE.createTopicForUnitImport(unitReport, node, parentNodeId);
            }
            catch (ImportExportException e) {
                return nbTopic;
            }
            if (newNode != null) {
                ++nbTopic;
            }
            if ((children = node.getChildrenDetails()) == null) {
                return nbTopic;
            }
            for (NodeDetail childNode : children) {
                nbTopic = this.processImportNodeInternal(childNode, newNode, gedIE, nbTopic, componentId, reportManager);
            }
        }
        return nbTopic;
    }
}

