/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.contribution.content.wysiwyg.WysiwygException;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.publication.model.CompletePublication;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.contribution.template.form.service.FormTemplateService;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.importexport.control.ComponentImportExport;
import org.silverpeas.core.importexport.control.ImportSettings;
import org.silverpeas.core.importexport.form.FormTemplateImportExport;
import org.silverpeas.core.importexport.form.XMLModelContentType;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.model.PublicationType;
import org.silverpeas.core.importexport.publication.PublicationContentType;
import org.silverpeas.core.importexport.report.ImportReportManager;
import org.silverpeas.core.importexport.report.MassiveReport;
import org.silverpeas.core.importexport.report.UnitReport;
import org.silverpeas.core.importexport.wysiwyg.WysiwygContentType;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailController;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.importexport.NodePositionType;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.UtilException;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class GEDImportExport
extends ComponentImportExport {
    private static final String GEDIMPORT_EXPORT_CREATE_PUBLICATION_CONTENT = "GEDImportExport.createPublicationContent()";
    private static final String IMPORT_EXPORT_EX_CANT_CREATE_CONTENT = "importExport.EX_CANT_CREATE_CONTENT";
    private PublicationService publicationService = null;
    private FormTemplateService formTemplateService = null;
    private NodeService nodeService = NodeService.get();

    public GEDImportExport(UserDetail curentUserDetail, String currentComponentId) {
        super(curentUserDetail, currentComponentId);
    }

    private PublicationService getPublicationService() {
        if (this.publicationService == null) {
            this.publicationService = PublicationService.get();
        }
        return this.publicationService;
    }

    private FormTemplateService getFormTemplateService() {
        if (this.formTemplateService == null) {
            this.formTemplateService = (FormTemplateService)ServiceProvider.getService(FormTemplateService.class, (Annotation[])new Annotation[0]);
        }
        return this.formTemplateService;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    private List<NodePositionType> processTopics(String userId, List<NodePositionType> topics, String componentId) {
        if (this.isKmax()) {
            return topics;
        }
        return this.getExistingTopics(userId, topics, componentId);
    }

    private PublicationDetail processPublicationDetail(UnitReport unitReport, ImportSettings settings, PublicationDetail pubDetailToCreate, List<NodePositionType> listOfNodeTypes) {
        List<NodePositionType> existingTopics = this.processTopics(settings.getUser().getId(), listOfNodeTypes, pubDetailToCreate.getPK().getInstanceId());
        if (existingTopics.isEmpty() && !this.isKmax()) {
            unitReport.setStatus(3);
            unitReport.setError(5);
            return null;
        }
        PublicationDetail pubDetTemp = null;
        boolean pubAlreadyExist = true;
        if (this.isKmax()) {
            pubAlreadyExist = false;
        }
        String pubId = null;
        boolean pubIdExists = false;
        if (pubDetailToCreate.getId() != null) {
            pubIdExists = StringUtil.isInteger((String)pubDetailToCreate.getId());
        }
        if (!pubIdExists) {
            pubAlreadyExist = false;
            if (settings.isPublicationMergeEnabled()) {
                try {
                    for (NodePositionType nodeType : existingTopics) {
                        pubDetTemp = this.getPublicationService().getDetailByNameAndNodeId(pubDetailToCreate.getPK(), pubDetailToCreate.getName(), nodeType.getId());
                        if (!pubDetTemp.canBeModifiedBy((User)this.getCurrentUserDetail())) continue;
                        pubAlreadyExist = true;
                    }
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).debug("This publication does not exist in this folder", new Object[0]);
                }
            }
        } else {
            pubDetTemp = this.getPublicationService().getDetail(pubDetailToCreate.getPK());
        }
        if (this.isKmax() && (pubDetTemp = this.getPublicationService().getDetailByName(pubDetailToCreate.getPK(), pubDetailToCreate.getName())) != null) {
            pubAlreadyExist = true;
        }
        if (pubAlreadyExist) {
            try {
                this.updatePublication(pubDetTemp, pubDetailToCreate, settings.getUser());
                unitReport.setStatus(1);
            }
            catch (Exception e) {
                unitReport.setError(0);
                return null;
            }
        } else {
            pubDetTemp = pubDetailToCreate;
        }
        if (pubIdExists && StringUtil.isDefined((String)pubDetailToCreate.getImage())) {
            this.processThumbnail(pubDetailToCreate.getImage(), pubDetTemp);
        }
        if (this.isKmax() && !pubAlreadyExist) {
            try {
                pubDetTemp = this.createPublication(pubDetTemp);
                unitReport.setStatus(0);
            }
            catch (Exception e) {
                unitReport.setError(0);
            }
        } else {
            NodePK topicPK;
            NodePositionType nodeType;
            Iterator<NodePositionType> itListNodeType = existingTopics.iterator();
            if (!pubAlreadyExist) {
                nodeType = itListNodeType.next();
                try {
                    topicPK = new NodePK(Integer.toString(nodeType.getId()), (ResourceReference)pubDetailToCreate.getPK());
                    pubId = this.createPublicationIntoTopic(pubDetTemp, topicPK, settings.getUser());
                    pubDetTemp.getPK().setId(pubId);
                }
                catch (Exception e) {
                    unitReport.setError(0);
                }
                unitReport.setStatus(0);
            }
            if (this.isKmelia()) {
                while (itListNodeType.hasNext()) {
                    nodeType = itListNodeType.next();
                    try {
                        topicPK = new NodePK(Integer.toString(nodeType.getId()), (ResourceReference)pubDetailToCreate.getPK());
                        PublicationPK pubPK = new PublicationPK(pubId, (ResourceReference)pubDetailToCreate.getPK());
                        if (pubAlreadyExist && this.isPublicationInTopic(pubDetTemp, nodeType)) continue;
                        this.addPublicationToTopic(pubPK, topicPK);
                    }
                    catch (Exception ex) {
                        unitReport.setError(0);
                    }
                }
            }
        }
        return pubDetTemp;
    }

    private boolean isPublicationInTopic(PublicationDetail pubDetail, NodePositionType nodeType) {
        try {
            return pubDetail != null && this.getPublicationService().getDetailByNameAndNodeId(pubDetail.getPK(), pubDetail.getName(), nodeType.getId()) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isKmelia() {
        return this.getCurrentComponentId().startsWith("kmelia");
    }

    public boolean isKmax() {
        return this.getCurrentComponentId().startsWith("kmax");
    }

    public void createPublicationContent(ImportReportManager reportManager, UnitReport unitReport, int pubId, PublicationContentType pubContent, String userId, String language) throws ImportExportException {
        WysiwygContentType wysiwygType = pubContent.getWysiwygContentType();
        XMLModelContentType xmlModel = pubContent.getXMLModelContentType();
        try {
            if (wysiwygType != null) {
                this.createWysiwygContent(unitReport, pubId, wysiwygType, userId, language);
            } else if (xmlModel != null) {
                this.createXMLModelContent(xmlModel, Integer.toString(pubId), userId);
            }
        }
        catch (ImportExportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImportExportException(GEDIMPORT_EXPORT_CREATE_PUBLICATION_CONTENT, IMPORT_EXPORT_EX_CANT_CREATE_CONTENT, "pubId = " + pubId, ex);
        }
    }

    private void createXMLModelContent(XMLModelContentType xmlModel, String pubId, String userId) throws PublicationTemplateException, FormException {
        PublicationTemplate pub;
        RecordSet set;
        DataRecord data;
        PublicationPK pubPK = new PublicationPK(pubId, this.getCurrentComponentId());
        PublicationDetail pubDetail = this.getPublicationService().getDetail(pubPK);
        String infoId = pubDetail.getInfoId();
        PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
        if (infoId == null || "0".equals(infoId)) {
            String xmlFormShortName = xmlModel.getName();
            pubDetail.setInfoId(xmlFormShortName);
            pubDetail.setIndexOperation(-1);
            this.getPublicationService().setDetail(pubDetail);
            publicationTemplateManager.addDynamicPublicationTemplate(this.getCurrentComponentId() + ":" + xmlFormShortName, xmlFormShortName + ".xml");
        }
        if ((data = (set = (pub = publicationTemplateManager.getPublicationTemplate(this.getCurrentComponentId() + ":" + xmlModel.getName())).getRecordSet()).getRecord(pubId)) == null) {
            data = set.getEmptyRecord();
            data.setId(pubId);
        }
        PagesContext formContext = new PagesContext();
        formContext.setComponentId(this.getCurrentComponentId());
        formContext.setObjectId(pubId);
        for (XMLField xmlField : xmlModel.getFields()) {
            String xmlFieldName = xmlField.getName();
            String xmlFieldValue = xmlField.getValue();
            try {
                FieldTemplate fieldTemplate;
                Field field = data.getField(xmlFieldName);
                if (field == null || (fieldTemplate = pub.getRecordTemplate().getFieldTemplate(xmlFieldName)) == null) continue;
                FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(field.getTypeName(), fieldTemplate.getDisplayerName());
                String fieldValue = field.getTypeName().equals("file") && StringUtil.isDefined((String)xmlFieldValue) ? new FormTemplateImportExport().manageFileField(new ResourceReference((WAPrimaryKey)pubPK), userId, xmlFieldValue) : xmlFieldValue;
                fieldDisplayer.update(fieldValue, field, fieldTemplate, formContext);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn("Can't import XML field '" + xmlFieldName + "'", new Object[]{e});
            }
        }
        set.save(data);
    }

    private void createWysiwygContent(UnitReport unitReport, int pubId, WysiwygContentType wysiwygType, String userId, String lang) throws ImportExportException {
        File wysiwygFile = null;
        String wysiwygText = null;
        try {
            Optional content;
            wysiwygFile = new File(FileUtil.convertPathToServerOS((String)wysiwygType.getPath()));
            if (!wysiwygFile.exists() && !wysiwygFile.isFile()) {
                String baseDir = this.resources.getString("importRepository", "");
                wysiwygFile = new File(FileUtil.convertPathToServerOS((String)(baseDir + File.separatorChar + wysiwygType.getPath())));
            }
            if ((content = FileFolderManager.getFileContent((String)wysiwygFile.getParent(), (String)wysiwygFile.getName())).isPresent()) {
                wysiwygText = (String)content.get();
            }
        }
        catch (UtilException ex) {
            unitReport.setError(11);
            if (wysiwygFile != null) {
                throw new ImportExportException(GEDIMPORT_EXPORT_CREATE_PUBLICATION_CONTENT, IMPORT_EXPORT_EX_CANT_CREATE_CONTENT, "file = " + wysiwygFile.getPath(), (Exception)((Object)ex));
            }
            throw new ImportExportException(GEDIMPORT_EXPORT_CREATE_PUBLICATION_CONTENT, IMPORT_EXPORT_EX_CANT_CREATE_CONTENT, "file = null", (Exception)((Object)ex));
        }
        if (wysiwygText == null) {
            unitReport.setError(11);
            throw new ImportExportException(GEDIMPORT_EXPORT_CREATE_PUBLICATION_CONTENT, IMPORT_EXPORT_EX_CANT_CREATE_CONTENT, "file = " + wysiwygFile.getPath());
        }
        if (WysiwygController.haveGotWysiwyg((String)this.getCurrentComponentId(), (String)String.valueOf(pubId), (String)lang)) {
            try {
                WysiwygController.deleteWysiwygAttachmentsOnly((String)this.getCurrentComponentId(), (String)String.valueOf(pubId));
            }
            catch (WysiwygException ignored) {
                SilverLogger.getLogger((Object)this).warn((Throwable)ignored);
            }
        }
        String newWysiwygText = this.replaceWysiwygImagesPathForImport(wysiwygText);
        newWysiwygText = this.removeWysiwygStringsForImport(newWysiwygText);
        newWysiwygText = this.replaceWysiwygStringsForImport(newWysiwygText);
        WysiwygController.createFileAndAttachment((String)newWysiwygText, (ResourceReference)new ResourceReference(String.valueOf(pubId), this.getCurrentComponentId()), (String)WysiwygController.WYSIWYG_CONTEXT, (String)userId, (String)lang);
    }

    private String replaceWysiwygImagesPathForImport(String wysiwygText) {
        int finPath = 0;
        StringBuilder newWysiwygText = new StringBuilder();
        if (wysiwygText.indexOf("img src=", finPath) == -1) {
            newWysiwygText.append(wysiwygText);
        } else {
            int debutPath;
            while ((debutPath = wysiwygText.indexOf("img src=", finPath)) != -1) {
                newWysiwygText.append(wysiwygText, finPath, debutPath += 9);
                int finPath1 = wysiwygText.indexOf(34, debutPath);
                int finPath2 = wysiwygText.indexOf("'", debutPath);
                finPath = Math.min(finPath1, finPath2);
                String imageSrc = wysiwygText.substring(debutPath, finPath);
                if (imageSrc.matches("(?i)^https?://.+")) {
                    newWysiwygText.append(imageSrc);
                    continue;
                }
                SilverLogger.getLogger((Object)this).warn("Local images not taken in charge. Image {0} not loaded", new Object[]{imageSrc});
            }
            newWysiwygText.append(wysiwygText.substring(finPath));
        }
        return newWysiwygText.toString();
    }

    private String replaceWysiwygStringsForImport(String wysiwygText) {
        SettingBundle mapping = ResourceLocator.getSettingBundle((String)"org.silverpeas.importExport.settings.stringsMapping");
        String newWysiwygText = wysiwygText;
        for (String oldString : mapping.keySet()) {
            String newString = mapping.getString(oldString);
            newWysiwygText = this.replaceWysiwygStringForImport(oldString, newString, newWysiwygText);
        }
        return newWysiwygText;
    }

    private String replaceWysiwygStringForImport(String oldCssClass, String newCssClass, String wysiwygText) {
        if (!StringUtil.isDefined((String)wysiwygText)) {
            return "";
        }
        return wysiwygText.replaceAll(oldCssClass, newCssClass);
    }

    private String removeWysiwygStringsForImport(String wysiwygText) {
        String currentWysiwygText = wysiwygText;
        SettingBundle resource = ResourceLocator.getSettingBundle((String)"org.silverpeas.importExport.settings.mapping");
        String dir = resource.getString("mappingDir");
        if (StringUtil.isDefined((String)dir)) {
            try (BufferedReader reader = new BufferedReader(new FileReader(dir + File.separator + "strings2Remove.txt"));){
                String ligne;
                while ((ligne = reader.readLine()) != null) {
                    if ("$$removeAnchors$$".equalsIgnoreCase(ligne)) {
                        currentWysiwygText = GEDImportExport.removeAnchors(currentWysiwygText);
                        continue;
                    }
                    currentWysiwygText = currentWysiwygText.replaceAll(ligne, "");
                }
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
        return currentWysiwygText;
    }

    private static String removeAnchors(String wysiwygText) {
        int fin = 0;
        StringBuilder newWysiwygText = new StringBuilder();
        if (wysiwygText.indexOf("<a name=", fin) == -1) {
            newWysiwygText.append(wysiwygText);
        } else {
            int debut;
            while ((debut = wysiwygText.indexOf("<a name=", fin)) != -1) {
                newWysiwygText.append(wysiwygText.substring(fin, debut));
                fin = wysiwygText.indexOf(62, debut += 8);
                debut = wysiwygText.indexOf("</a>", fin);
                newWysiwygText.append(wysiwygText.substring(fin + 1, debut));
                fin = debut + 4;
            }
            newWysiwygText.append(wysiwygText.substring(fin));
        }
        return newWysiwygText.toString();
    }

    public void copyWysiwygImageForExport(String pubId, String componentId, String exportPublicationPath) {
        ResourceReference foreignKey = new ResourceReference(pubId, componentId);
        SimpleDocumentList documents = AttachmentServiceProvider.getAttachmentService().listAllDocumentsByForeignKey(foreignKey, null);
        documents.stream().filter(a2 -> DocumentType.image == a2.getDocumentType() || DocumentType.video == a2.getDocumentType()).filter(a2 -> a2.isDownloadAllowedForRolesFrom((User)this.getCurrentUserDetail())).forEach(a2 -> {
            try {
                FileRepositoryManager.copyFile((String)a2.getAttachmentPath(), (String)(exportPublicationPath + File.separator + a2.getFilename()));
            }
            catch (IOException ex) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex);
            }
        });
    }

    private List<NodePositionType> getExistingTopics(String userId, List<NodePositionType> nodeTypes, String componentId) {
        ArrayList<NodePositionType> topics = new ArrayList<NodePositionType>();
        for (NodePositionType node : nodeTypes) {
            if (node.getId() >= 0) {
                if (!this.isTopicExist(node.getId(), componentId)) continue;
                topics.add(node);
                continue;
            }
            if (!StringUtil.isDefined((String)node.getExplicitPath()) || node.getId() != -1) continue;
            String[] path = node.getExplicitPath().substring(1).split("/");
            NodePK nodePK = new NodePK("unknown", componentId);
            String parentId = "0";
            for (String name : path) {
                NodeDetail createdNode;
                NodeDetail existingNode = this.getNodeService().getDetailByNameAndFatherId(nodePK, name, Integer.parseInt(parentId));
                if (existingNode != null) {
                    parentId = existingNode.getNodePK().getId();
                    continue;
                }
                NodeDetail newNode = new NodeDetail();
                newNode.setName(name);
                newNode.setNodePK(new NodePK("unknown", componentId));
                newNode.setFatherPK(new NodePK(parentId, componentId));
                newNode.setCreatorId(userId);
                try {
                    createdNode = this.getNodeService().createNode(newNode);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)e);
                    return new ArrayList<NodePositionType>();
                }
                parentId = createdNode.getId();
            }
            node.setId(Integer.parseInt(parentId));
            topics.add(node);
        }
        return topics;
    }

    private boolean isTopicExist(int nodeId, String componentId) {
        try {
            this.getNodeService().getHeader(new NodePK(Integer.toString(nodeId), "useless", componentId));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected abstract NodePK addSubTopicToTopic(NodeDetail var1, int var2, UnitReport var3) throws ImportExportException;

    protected abstract NodeDetail addSubTopicToTopic(NodeDetail var1, int var2, MassiveReport var3) throws ImportExportException;

    public NodeDetail createTopicForUnitImport(UnitReport unitReport, NodeDetail nodeDetail, int parentTopicId) throws ImportExportException {
        unitReport.setItemName(nodeDetail.getName());
        NodePK nodePk = this.addSubTopicToTopic(nodeDetail, parentTopicId, unitReport);
        try {
            return this.getNodeService().getDetail(nodePk);
        }
        catch (Exception ex) {
            unitReport.setError(5);
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
            throw new ImportExportException("GEDImportExport.createTopicForUnitImport", "importExport.EX_NODE_CREATE", ex);
        }
    }

    public PublicationDetail createPublicationForUnitImport(UnitReport unitReport, ImportSettings settings, PublicationDetail pubDetail, List<NodePositionType> listNodeType) {
        unitReport.setItemName(pubDetail.getName());
        return this.processPublicationDetail(unitReport, settings, pubDetail, listNodeType);
    }

    public PublicationDetail createPublicationForMassiveImport(UnitReport unitReport, PublicationDetail pubDetail, ImportSettings settings) {
        unitReport.setItemName(pubDetail.getName());
        NodePositionType nodePosType = new NodePositionType();
        nodePosType.setId(Integer.valueOf(settings.getFolderId()).intValue());
        ArrayList<NodePositionType> listNodeType = new ArrayList<NodePositionType>(1);
        listNodeType.add(nodePosType);
        return this.processPublicationDetail(unitReport, settings, pubDetail, listNodeType);
    }

    public NodeDetail addSubTopicToTopic(File directory, int topicId, MassiveReport massiveReport) throws ImportExportException {
        try {
            String directoryName = directory.getName();
            NodeDetail nodeDetail = new NodeDetail("unknow", directoryName, directoryName, 0, "useless");
            return this.addSubTopicToTopic(nodeDetail, topicId, massiveReport);
        }
        catch (Exception ex) {
            throw new ImportExportException("GEDImportExport.addSubTopicToTopic", "importExport.EX_NODE_CREATE", ex);
        }
    }

    public abstract int getSilverObjectId(String var1);

    public PublicationType getPublicationCompleteById(String pubId, String componentId) {
        PublicationType publicationType = new PublicationType();
        CompletePublication pubComplete = this.getCompletePublication(new PublicationPK(pubId, this.getCurrentComponentId()));
        PublicationDetail publicationDetail = pubComplete.getPublicationDetail();
        PublicationContentType pubContent = null;
        try {
            if (!StringUtil.isInteger((String)publicationDetail.getInfoId())) {
                pubContent = new PublicationContentType();
                List xmlFields = this.getFormTemplateService().getXMLFieldsForExport(publicationDetail.getPK().getInstanceId() + ":" + publicationDetail.getInfoId(), pubId);
                XMLModelContentType xmlModel = new XMLModelContentType(publicationDetail.getInfoId());
                xmlModel.setFields(xmlFields);
                pubContent.setXMLModelContentType(xmlModel);
            } else if (WysiwygController.haveGotWysiwyg((String)publicationDetail.getPK().getInstanceId(), (String)pubId, (String)I18NHelper.checkLanguage((String)publicationDetail.getLanguage()))) {
                pubContent = new PublicationContentType();
                WysiwygContentType wysiwygContentType = new WysiwygContentType();
                String wysiwygFileName = WysiwygController.getWysiwygFileName((String)pubId, (String)I18NHelper.checkLanguage((String)publicationDetail.getLanguage()));
                wysiwygContentType.setPath(wysiwygFileName);
                pubContent.setWysiwygContentType(wysiwygContentType);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(new SilverpeasExceptionMessages.LightExceptionMessage((Object)this, e).singleLineWith(MessageFormat.format("Cannot export content of publication #{0} on instanceId #{1} ({2})", pubId, publicationDetail.getPK().getInstanceId(), e.getMessage())), new Object[0]);
        }
        publicationType.setPublicationContentType(pubContent);
        publicationType.setPublicationDetail(publicationDetail);
        publicationType.setId(Integer.parseInt(pubId));
        publicationType.setComponentId(componentId);
        User creator = publicationDetail.getCreator();
        if (creator != null) {
            String nomPrenomCreator = creator.getDisplayedName();
            publicationDetail.setCreatorName(nomPrenomCreator);
        }
        return publicationType;
    }

    public List<Location> getAllTopicsOfPublicationInSameComponentInstance(PublicationPK pubPK) {
        ArrayList<Location> result = new ArrayList<Location>();
        this.getPublicationService().getMainLocation(pubPK).ifPresent(result::add);
        return result;
    }

    public List<Location> getAliases(PublicationPK pubPK) {
        return this.getPublicationService().getAllAliases(pubPK);
    }

    public List<NodePK> getTopicTree(NodePK pk) {
        ArrayList<NodePK> listNodePk = new ArrayList<NodePK>();
        NodePath path = this.getNodeService().getPath(pk);
        for (NodeDetail detail : path) {
            listNodePk.add(detail.getNodePK());
        }
        return listNodePk;
    }

    public abstract void publicationNotClassifiedOnPDC(String var1);

    protected abstract PublicationDetail createPublication(PublicationDetail var1);

    public Collection<Coordinate> getPublicationCoordinates(String pubId, String componentId) throws ImportExportException {
        try {
            return this.getPublicationService().getCoordinates(pubId, componentId);
        }
        catch (Exception e) {
            throw new ImportExportException("GEDImportExport.getPublicationCoordinates(String)", "importExport.EX_GET_SILVERPEASOBJECTID", "pubId = " + pubId, e);
        }
    }

    private void processThumbnail(String filePath, PublicationDetail pubDetail) {
        String logicalName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        String type = FileRepositoryManager.getFileExtension((String)logicalName);
        String mimeType = FileUtil.getMimeType((String)logicalName);
        String physicalName = Long.toString(System.currentTimeMillis()) + "." + type;
        if (FileUtil.isImage((String)logicalName)) {
            String dest = FileRepositoryManager.getAbsolutePath((String)pubDetail.getPK().getInstanceId()) + "images" + File.separator + physicalName;
            try {
                FileRepositoryManager.copyFile((String)filePath, (String)dest);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            ThumbnailDetail thumbnailDetail = new ThumbnailDetail(pubDetail.getPK().getComponentName(), Integer.valueOf(pubDetail.getPK().getId()).intValue(), 1);
            thumbnailDetail.setOriginalFileName(physicalName);
            thumbnailDetail.setOriginalFileName(mimeType);
            ThumbnailController.createThumbnail((ThumbnailDetail)thumbnailDetail, (int)50, (int)50);
        }
    }

    protected abstract void updatePublication(PublicationDetail var1, PublicationDetail var2, UserDetail var3);

    protected abstract String createPublicationIntoTopic(PublicationDetail var1, NodePK var2, UserDetail var3);

    protected abstract void addPublicationToTopic(PublicationPK var1, NodePK var2);

    protected abstract CompletePublication getCompletePublication(PublicationPK var1);
}

